/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dataflow.ui.table;

import org.eclipse.eef.EEFCustomWidgetDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.palladiosimulator.dataflow.ui.table.TableController;

public class TableLifeCycleManager
extends AbstractEEFWidgetLifecycleManager {
    private EEFCustomWidgetDescription description;
    private TableViewer tableViewer;
    private ComposedAdapterFactory composedAdapterFactory;
    private SelectionListener onClickListener;
    private TableController controller;

    public TableLifeCycleManager(EEFCustomWidgetDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        Table table = formContainer.getWidgetFactory().createTable(parent, 68108);
        this.tableViewer = new TableViewer(table);
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.composedAdapterFactory, (Viewer)this.tableViewer)));
        this.controller = new TableController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        System.out.println("About to be shown");
        this.onClickListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((IStructuredSelection)TableLifeCycleManager.this.tableViewer.getSelection()).getFirstElement();
                TableLifeCycleManager.this.controller.handleClick(selection);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                Object selection = ((IStructuredSelection)TableLifeCycleManager.this.tableViewer.getSelection()).getFirstElement();
                TableLifeCycleManager.this.controller.handleClick(selection);
            }
        };
        this.tableViewer.getTable().addSelectionListener(this.onClickListener);
    }

    public void refresh() {
        super.refresh();
        this.controller.refresh();
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        this.tableViewer.getTable().removeSelectionListener(this.onClickListener);
        this.onClickListener = null;
    }

    protected IEEFWidgetController getController() {
        return this.controller;
    }

    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    protected Control getValidationControl() {
        return this.tableViewer.getTable();
    }

    public void dispose() {
        super.dispose();
        this.composedAdapterFactory.dispose();
    }

    protected void setEnabled(boolean isEnabled) {
        this.tableViewer.getTable().setEnabled(isEnabled);
    }
}

