/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.entity;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.palladiosimulator.envdyn.api.exception.EnvironmentalDynamicsException;
import org.palladiosimulator.envdyn.api.util.TemplateDefinitionsQuerying;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;

public class TemplateVariableTopology {
    private final TemplateDefinitionsQuerying templateQuery;
    private final Map<Integer, TemplateVariable> topologyLevels;

    public TemplateVariableTopology(TemplateDefinitionsQuerying templateQuery) {
        this.templateQuery = templateQuery;
        this.topologyLevels = Maps.newHashMap();
        this.orderTopologically();
    }

    public TopologyIterator topologicallyOrderedTemplates() {
        return new TopologyIterator();
    }

    private void orderTopologically() {
        Set<TemplateVariable> templates = this.templateQuery.getTemplateVariables();
        int topologyDepth = templates.size();
        int i = 0;
        while (i < topologyDepth) {
            TemplateVariable template = this.selectAnyWithOrderedParents(templates);
            this.addToTopology(i, template);
            templates.remove(template);
            ++i;
        }
    }

    private TemplateVariable selectAnyWithOrderedParents(Set<TemplateVariable> templates) {
        for (TemplateVariable any : templates) {
            Set<TemplateVariable> parents = this.templateQuery.filterAllParentsOf(any);
            if (!this.inTopology(parents)) continue;
            return any;
        }
        throw new EnvironmentalDynamicsException("The templates cannot be ordered topologically.");
    }

    private boolean inTopology(Set<TemplateVariable> parents) {
        if (parents.isEmpty()) {
            return true;
        }
        return parents.stream().allMatch(p -> TemplateDefinitionsQuerying.contains(p, this.topologyLevels.values()));
    }

    private void addToTopology(Integer level, TemplateVariable template) {
        this.topologyLevels.put(level, template);
    }

    public class TopologyIterator
    implements Iterator<TemplateVariable> {
        private int levelCounter = 0;
        private int increment = 1;

        @Override
        public boolean hasNext() {
            return this.increment > 0 ? this.levelCounter != TemplateVariableTopology.this.topologyLevels.size() : this.levelCounter < 0;
        }

        @Override
        public TemplateVariable next() {
            TemplateVariable next = TemplateVariableTopology.this.topologyLevels.get(this.levelCounter);
            this.incrementCounter();
            return next;
        }

        public void reverse() {
            if (this.levelCounter != 0) {
                throw new EnvironmentalDynamicsException("This method has to be executed before traversing.");
            }
            this.levelCounter = TemplateVariableTopology.this.topologyLevels.size() - 1;
            this.increment = -1;
        }

        private void incrementCounter() {
            this.levelCounter += this.increment;
        }
    }
}

