/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.envdyn.environment.templatevariable.Argument;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableGroup;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;

public class AnnotationHandler {
    private final TemplateVariableDefinitions definitions;

    public AnnotationHandler(TemplateVariableDefinitions definitions) {
        this.definitions = definitions;
    }

    public static String getTaggedId(EObject appliedElement, Stereotype tag) {
        return (String)StereotypeAPI.getTaggedValue((EObject)appliedElement, (String)"taggedValue", (String)tag.getName());
    }

    public static Stereotype getInstantiationTag(EObject obj) {
        return StereotypeAPI.getAppliedStereotypes((EObject)obj).stream().filter(s -> s.getName().equals("InstantiationTag")).findFirst().get();
    }

    public static List<EObject> filterAnnotated(ResourceSet appliedModels) {
        ArrayList annotated = Lists.newArrayList();
        int i = 0;
        while (i < appliedModels.getResources().size()) {
            Resource appliedModel = (Resource)appliedModels.getResources().get(i);
            annotated.addAll(AnnotationHandler.filterAnnotatedElements(appliedModel));
            ++i;
        }
        return annotated;
    }

    private static List<EObject> filterAnnotatedElements(Resource appliedModel) {
        ArrayList annotatedElements = Lists.newArrayList();
        appliedModel.getAllContents().forEachRemaining(annotatedElements::add);
        annotatedElements.removeIf(AnnotationHandler.noStereotypeIsApplied());
        return annotatedElements;
    }

    private static Predicate<EObject> noStereotypeIsApplied() {
        return obj -> !StereotypeAPI.isStereotypeApplied((EObject)obj, (String)"InstantiationTag");
    }

    public Optional<TemplateVariableGroup> getTemplateGroup(Stereotype tag, EObject appliedElement) {
        return Optional.ofNullable((TemplateVariableGroup)this.getAppliedParameter(tag, appliedElement, "templateGroup"));
    }

    public Optional<TemplateVariable> getTemplate(Stereotype tag, EObject appliedElement) {
        return Optional.ofNullable((TemplateVariable)this.getAppliedParameter(tag, appliedElement, "template"));
    }

    public Optional<Argument> getArgument(EObject appliedElement, Stereotype tag) {
        return Optional.ofNullable((Argument)this.getAppliedParameter(tag, appliedElement, "argument"));
    }

    private Object getAppliedParameter(Stereotype tag, EObject appliedElement, String refName) {
        StereotypeApplication application = StereotypeAPI.getStereotypeApplication((EObject)appliedElement, (Stereotype)tag);
        application.eResource().getResourceSet().getResources().add((Object)this.definitions.eResource());
        return application.eGet(StereotypeAPI.getParameter((Stereotype)tag, (String)refName));
    }
}

