/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.entity.bn;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.envdyn.api.entity.ProbabilisticModel;
import org.palladiosimulator.envdyn.api.entity.TemplateVariableTopology;
import org.palladiosimulator.envdyn.api.entity.bn.ConditionalInputValueUtil;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.api.entity.bn.ProbabilityDistributionHandler;
import org.palladiosimulator.envdyn.api.exception.EnvironmentalDynamicsException;
import org.palladiosimulator.envdyn.api.util.TemplateDefinitionsQuerying;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.templatevariable.DependenceRelation;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import tools.mdsd.probdist.api.builder.ProbabilityDistributionBuilder;
import tools.mdsd.probdist.api.entity.Conditionable;
import tools.mdsd.probdist.api.entity.ConditionableProbabilityDistribution;
import tools.mdsd.probdist.api.entity.ProbabilityDistributionFunction;
import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.factory.ProbabilityCalculator;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributionfunction.Domain;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;

public class BayesianNetwork<I extends Value<?>>
extends ProbabilityDistributionFunction<List<InputValue<I>>>
implements ProbabilisticModel<InputValue<I>> {
    private final GroundProbabilisticNetwork groundNetwork;
    private final LocalProbabilisticModelHandler probModelHandler;
    private final ProbabilityCalculator<I> probabilityCalculator;
    private final ConditionalInputValueUtil<I> conditionalInputValueUtil = new ConditionalInputValueUtil();

    public BayesianNetwork(ProbabilityDistributionSkeleton distSkeleton, GroundProbabilisticNetwork groundNetwork, IProbabilityDistributionFactory<I> probabilityDistributionFactory) {
        super(distSkeleton);
        this.groundNetwork = groundNetwork;
        this.probModelHandler = new LocalProbabilisticModelHandler(probabilityDistributionFactory);
        this.probabilityCalculator = probabilityDistributionFactory.getProbabilityCalculator();
        this.checkConsistency();
    }

    private void checkConsistency() {
        this.groundNetwork.getLocalProbabilisticModels().forEach(this::allParentsInstantiated);
    }

    private void allParentsInstantiated(LocalProbabilisticNetwork localNetwork) {
        for (GroundRandomVariable each : localNetwork.getGroundRandomVariables()) {
            if (this.allParentsInstantiated(each, localNetwork)) continue;
            throw new EnvironmentalDynamicsException(String.format("The parents of ground variable with template %s is not instantiated correctly.", each.getInstantiatedTemplate().getEntityName()));
        }
    }

    private boolean allParentsInstantiated(GroundRandomVariable variable, LocalProbabilisticNetwork localNetwork) {
        TemplateVariable templateToCheck;
        TemplateDefinitionsQuerying templateQuery = TemplateDefinitionsQuerying.withTemplateScope(BayesianNetwork.getTemplates(localNetwork));
        Set<TemplateVariable> parents = templateQuery.filterAllParentsOf(templateToCheck = variable.getInstantiatedTemplate());
        if (parents.isEmpty()) {
            return true;
        }
        for (TemplateVariable eachParent : parents) {
            DependenceRelation relation;
            List<GroundRandomVariable> instantiated = this.filterGroundVariablesInstantiating(eachParent, localNetwork);
            if (!instantiated.isEmpty() || (relation = templateQuery.findRelation(eachParent, templateToCheck).get()).isContingent()) continue;
            return false;
        }
        return true;
    }

    private List<GroundRandomVariable> filterGroundVariablesInstantiating(TemplateVariable template, LocalProbabilisticNetwork localNetwork) {
        return localNetwork.getGroundRandomVariables().stream().filter(v -> TemplateDefinitionsQuerying.areEqual(template, v.getInstantiatedTemplate())).collect(Collectors.toList());
    }

    private List<GroundRandomVariable> filterGroundVariablesInstantiating(Set<TemplateVariable> templates, LocalProbabilisticNetwork localNetwork) {
        return templates.stream().flatMap(t -> this.filterGroundVariablesInstantiating((TemplateVariable)t, localNetwork).stream()).collect(Collectors.toList());
    }

    public Double probability(List<InputValue<I>> inputs) {
        this.checkValidity(inputs);
        return this.calculateProability(inputs);
    }

    public void init(Optional<ISeedProvider> seedProvider) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        for (LocalProbabilisticNetwork eachLocal : this.groundNetwork.getLocalProbabilisticModels()) {
            for (GroundRandomVariable eachVariable : eachLocal.getGroundRandomVariables()) {
                ProbabilityDistributionFunction pdf = this.probModelHandler.getPDF(eachVariable);
                pdf.init(seedProvider);
            }
        }
    }

    public List<InputValue<I>> sample() {
        if (!this.initialized) {
            throw new RuntimeException("not initialized");
        }
        return this.sampleNext();
    }

    @Override
    public Double infer(List<InputValue<I>> inputs) {
        throw new UnsupportedOperationException("The method is not implemented yet.");
    }

    @Override
    public void learn(List<InputValue<I>> trainingData) {
        throw new UnsupportedOperationException("The method is not implemented yet.");
    }

    public static Set<TemplateVariable> getTemplates(LocalProbabilisticNetwork localNetwork) {
        return localNetwork.getGroundRandomVariables().stream().map(GroundRandomVariable::getInstantiatedTemplate).distinct().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public GroundProbabilisticNetwork get() {
        return this.groundNetwork;
    }

    public List<LocalProbabilisticNetwork> getLocalProbabilisticNetworks() {
        return this.groundNetwork.getLocalProbabilisticModels();
    }

    public List<GroundRandomVariable> getGroundVariables() {
        return this.groundNetwork.getLocalProbabilisticModels().stream().flatMap(v -> v.getGroundRandomVariables().stream()).collect(Collectors.toList());
    }

    private void checkValidity(List<InputValue<I>> inputs) {
        if (this.getGroundVariables().size() != inputs.size()) {
            throw new IllegalArgumentException("The input size does not match the size network variables.");
        }
        for (InputValue<I> each : inputs) {
            if (this.getGroundVariables().contains(each.getVariable())) continue;
            throw new IllegalArgumentException(String.format("The network does not contain the ground random variable for template %s", each.getVariable().getInstantiatedTemplate().getEntityName()));
        }
    }

    private double calculateProability(List<InputValue<I>> inputs) {
        double probability = 1.0;
        for (LocalProbabilisticNetwork eachLocal : this.groundNetwork.getLocalProbabilisticModels()) {
            for (GroundRandomVariable eachVariable : this.orderGroundVariablesTopologically(eachLocal)) {
                InputValue<I> input = this.conditionalInputValueUtil.getInputValue(eachVariable, inputs);
                ProbabilityDistributionFunction<I> pdf = this.getPDF(eachVariable, inputs);
                I value = input.getValue();
                probability *= this.probabilityCalculator.calculateLocalProbability(pdf, value);
            }
        }
        return probability;
    }

    private List<InputValue<I>> sampleNext() {
        ArrayList samples = Lists.newArrayList();
        for (LocalProbabilisticNetwork eachLocal : this.groundNetwork.getLocalProbabilisticModels()) {
            for (GroundRandomVariable eachVariable : this.orderGroundVariablesTopologically(eachLocal)) {
                ProbabilityDistributionFunction<I> pdf = this.getPDF(eachVariable, samples);
                Value value = (Value)pdf.sample();
                samples.add(InputValue.create(value, eachVariable));
            }
        }
        return samples;
    }

    private List<GroundRandomVariable> orderGroundVariablesTopologically(LocalProbabilisticNetwork localNetwork) {
        ArrayList topologicallyOrdered = Lists.newArrayList();
        TemplateVariableTopology.TopologyIterator iterator = this.getTopologyIterator(localNetwork);
        while (iterator.hasNext()) {
            topologicallyOrdered.addAll(this.filterGroundVariablesInstantiating(iterator.next(), localNetwork));
        }
        return topologicallyOrdered;
    }

    private TemplateVariableTopology.TopologyIterator getTopologyIterator(LocalProbabilisticNetwork localNetwork) {
        TemplateDefinitionsQuerying templateQuery = TemplateDefinitionsQuerying.withTemplateScope(BayesianNetwork.getTemplates(localNetwork));
        return new TemplateVariableTopology(templateQuery).topologicallyOrderedTemplates();
    }

    protected ProbabilityDistributionFunction<I> getPDF(GroundRandomVariable variable, List<InputValue<I>> history) {
        ProbabilityDistributionFunction pdf = this.probModelHandler.getPDF(variable);
        if (pdf instanceof ConditionableProbabilityDistribution) {
            ConditionableProbabilityDistribution conditionableProbabilityDistribution = (ConditionableProbabilityDistribution)pdf;
            List<Conditionable.Conditional<I>> conditionals = this.resolveConditionals(variable, history);
            conditionableProbabilityDistribution.given(conditionals);
        }
        return pdf;
    }

    private List<Conditionable.Conditional<I>> resolveConditionals(GroundRandomVariable variable, List<InputValue<I>> history) {
        LocalProbabilisticNetwork localNetwork = (LocalProbabilisticNetwork)variable.eContainer();
        TemplateDefinitionsQuerying templateQuery = TemplateDefinitionsQuerying.withTemplateScope(BayesianNetwork.getTemplates(localNetwork));
        List<GroundRandomVariable> instantiatedParents = this.filterGroundVariablesInstantiating(templateQuery.filterAllParentsOf(variable.getInstantiatedTemplate()), localNetwork);
        return instantiatedParents.stream().map(each -> this.conditionalInputValueUtil.getInputValue((GroundRandomVariable)each, history)).map(this::toConditional).collect(Collectors.toList());
    }

    private Conditionable.Conditional<I> toConditional(InputValue<I> value) {
        return new Conditionable.Conditional(this.getDomain(value), value.getValue());
    }

    private Domain getDomain(InputValue<I> input) {
        return input.getValue().getDomain();
    }

    private class LocalProbabilisticModelHandler
    extends ProbabilityDistributionHandler<I> {
        private final IProbabilityDistributionFactory<I> probabilityDistributionFactory;

        public LocalProbabilisticModelHandler(IProbabilityDistributionFactory<I> probabilityDistributionFactory) {
            this.probabilityDistributionFactory = probabilityDistributionFactory;
        }

        @Override
        protected void initialize() {
            BayesianNetwork.this.getLocalProbabilisticNetworks().forEach(this::createAndCache);
        }

        private void createAndCache(LocalProbabilisticNetwork localNetwork) {
            TemplateDefinitionsQuerying defQuery = TemplateDefinitionsQuerying.withTemplateScope(BayesianNetwork.getTemplates(localNetwork));
            for (GroundRandomVariable each : localNetwork.getGroundRandomVariables()) {
                if (defQuery.filterAllParentsOf(each.getInstantiatedTemplate()).isEmpty()) {
                    this.createAndCachePD(each);
                    continue;
                }
                this.createAndCacheCPD(each);
            }
        }

        private void createAndCachePD(GroundRandomVariable variable) {
            ProbabilityDistribution distribution = variable.getDescriptiveModel().getDistribution();
            ProbabilityDistributionBuilder probabilityDistributionBuilder = this.probabilityDistributionFactory.getProbabilityDistributionBuilder();
            ProbabilityDistributionFunction pdf = probabilityDistributionBuilder.withStructure(distribution).build();
            this.cache(variable, pdf);
        }

        private void createAndCacheCPD(GroundRandomVariable variable) {
            ProbabilityDistribution distribution = variable.getDescriptiveModel().getDistribution();
            ProbabilityDistributionBuilder probabilityDistributionBuilder = this.probabilityDistributionFactory.getProbabilityDistributionBuilder();
            ProbabilityDistributionFunction pdf = probabilityDistributionBuilder.withStructure(distribution).asConditionalProbabilityDistribution().build();
            this.cache(variable, pdf);
        }
    }
}

