/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.entity.bn;

import java.util.List;
import java.util.stream.Collectors;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import tools.mdsd.probdist.api.entity.Conditionable;
import tools.mdsd.probdist.api.entity.Value;

public class ConditionalInputValueUtil<I extends Value<?>> {
    public List<Conditionable.Conditional<I>> asConditionals(List<DynamicBayesianNetwork.ConditionalInputValue<I>> conditionals) {
        return conditionals.stream().map(Conditionable.Conditional.class::cast).collect(Collectors.toList());
    }

    public List<DynamicBayesianNetwork.ConditionalInputValue<I>> toConditionalInputs(List<InputValue<I>> inputs) {
        return inputs.stream().map(this::toConditionalInput).collect(Collectors.toList());
    }

    private DynamicBayesianNetwork.ConditionalInputValue<I> toConditionalInput(InputValue<I> input) {
        return DynamicBayesianNetwork.ConditionalInputValue.create(new Conditionable.Conditional(input.getValue().getDomain(), input.getValue()), input.getVariable());
    }

    public List<InputValue<I>> toInputValues(List<DynamicBayesianNetwork.ConditionalInputValue<I>> conditionals) {
        return conditionals.stream().map(this::toInputValue).collect(Collectors.toList());
    }

    private InputValue<I> toInputValue(DynamicBayesianNetwork.ConditionalInputValue<I> conditional) {
        return InputValue.create(conditional.getValue(), conditional.getGroundVariable());
    }

    public InputValue<I> getInputValue(GroundRandomVariable variable, List<InputValue<I>> inputs) {
        return inputs.stream().filter(input -> input.getVariable().getId().equals(variable.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The network does not contain the ground random variable for template %s", variable.getInstantiatedTemplate().getEntityName())));
    }
}

