/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.generator.annotation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.envdyn.api.exception.EnvironmentalDynamicsException;
import org.palladiosimulator.envdyn.api.generator.NetworkInstantiationStrategy;
import org.palladiosimulator.envdyn.api.generator.annotation.InstantiationContext;
import org.palladiosimulator.envdyn.api.generator.annotation.InstantiationContextProvider;
import org.palladiosimulator.envdyn.api.util.AnnotationHandler;
import org.palladiosimulator.envdyn.api.util.TemplateDefinitionsQuerying;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticModel;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.StaticmodelFactory;
import org.palladiosimulator.envdyn.environment.templatevariable.DependenceRelation;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateFactor;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;

public class AnnotationInstantiationStrategy
implements NetworkInstantiationStrategy {
    private static final StaticmodelFactory MODEL_FACTORY = StaticmodelFactory.eINSTANCE;
    private final InstantiationContextProvider contextProvider;

    public AnnotationInstantiationStrategy(TemplateVariableDefinitions templateDefinitions) {
        this.contextProvider = new InstantiationContextProvider(templateDefinitions);
    }

    @Override
    public GroundProbabilisticNetwork instantiate(ResourceSet appliedModels) {
        this.contextProvider.resolve(appliedModels);
        return this.instantiateNetwork();
    }

    private GroundProbabilisticNetwork instantiateNetwork() {
        ArrayList localNetworks = Lists.newArrayList();
        ArrayList groundModels = Lists.newArrayList();
        for (String eachTag : this.contextProvider.getInstantiationTags()) {
            InstantiationContextProvider.ResolvedInstantiationContext resolved = this.contextProvider.getInstantiationContextsOf(eachTag);
            List<GroundRandomVariable> groundVariables = this.instantiateGroundVariables(resolved);
            for (GroundRandomVariable each : groundVariables) {
                groundModels.add(this.instantiateAndSetLocalModel(each, resolved));
            }
            localNetworks.add(this.createLocalProbabilisticModel(groundVariables));
        }
        return this.instantiateGroundNetwork(groundModels, localNetworks);
    }

    private LocalProbabilisticNetwork createLocalProbabilisticModel(List<GroundRandomVariable> variables) {
        LocalProbabilisticNetwork model = MODEL_FACTORY.createLocalProbabilisticNetwork();
        model.getGroundRandomVariables().addAll(variables);
        return model;
    }

    private List<GroundRandomVariable> instantiateGroundVariables(InstantiationContextProvider.ResolvedInstantiationContext resolved) {
        ArrayList result = Lists.newArrayList();
        for (TemplateVariable each : resolved.getInstantiatedTemplates()) {
            if (resolved.singleInstantiation(each)) {
                result.add(this.createRandomVariable(each, resolved));
                continue;
            }
            result.addAll(this.createRandomVariables(each, resolved));
        }
        return result;
    }

    private GroundRandomVariable createRandomVariable(TemplateVariable template, InstantiationContextProvider.ResolvedInstantiationContext resolved) {
        TemplateDefinitionsQuerying defQuery = TemplateDefinitionsQuerying.withBaseTemplatesOnly((TemplateVariableDefinitions)template.eContainer());
        Set<EObject> appliedObjects = resolved.filterElementsInstantiating(template);
        Set<DependenceRelation> dependenceStructure = defQuery.filterRelationsWithTarget(Sets.newHashSet((Object[])new TemplateVariable[]{template}));
        return this.createRandomVariable(template, dependenceStructure, appliedObjects);
    }

    private List<GroundRandomVariable> createRandomVariables(TemplateVariable template, InstantiationContextProvider.ResolvedInstantiationContext resolved) {
        ArrayList variables = Lists.newArrayList();
        for (InstantiationContext each : resolved.filterContextsIncluding(template)) {
            TemplateDefinitionsQuerying defQuery = TemplateDefinitionsQuerying.withBaseTemplatesOnly((TemplateVariableDefinitions)template.eContainer());
            HashSet appliedObjects = Sets.newHashSet((Object[])new EObject[]{each.getAppliedObject()});
            Set<DependenceRelation> dependenceStructure = defQuery.filterRelationsWithTarget(Sets.newHashSet((Object[])new TemplateVariable[]{template}));
            variables.add(this.createRandomVariable(template, dependenceStructure, appliedObjects));
        }
        return variables;
    }

    private GroundRandomVariable createRandomVariable(TemplateVariable template, Set<DependenceRelation> dependenceStructure, Set<EObject> appliedObjects) {
        GroundRandomVariable variable = MODEL_FACTORY.createGroundRandomVariable();
        variable.setEntityName(this.constructNameOf(template, appliedObjects));
        variable.getAppliedObjects().addAll(appliedObjects);
        variable.setInstantiatedTemplate(template);
        variable.getDependenceStructure().addAll(dependenceStructure);
        return variable;
    }

    private GroundProbabilisticModel instantiateAndSetLocalModel(GroundRandomVariable variable, InstantiationContextProvider.ResolvedInstantiationContext resolved) {
        return this.createAndSetLocalModel(variable, this.resolveTemplateFactor(variable, resolved));
    }

    private GroundProbabilisticModel createAndSetLocalModel(GroundRandomVariable variable, TemplateFactor factor) {
        GroundProbabilisticModel model = this.createLocalModel(variable, factor);
        variable.setDescriptiveModel(model);
        return model;
    }

    private GroundProbabilisticModel createLocalModel(GroundRandomVariable variable, TemplateFactor factor) {
        GroundProbabilisticModel localModel = MODEL_FACTORY.createGroundProbabilisticModel();
        localModel.setEntityName(this.constructNameOf(variable, factor));
        localModel.setInstantiatedFactor(factor);
        return localModel;
    }

    private TemplateFactor resolveTemplateFactor(GroundRandomVariable variable, InstantiationContextProvider.ResolvedInstantiationContext resolved) {
        TemplateDefinitionsQuerying defQuery = TemplateDefinitionsQuerying.withTemplateScope(resolved.getInstantiatedTemplates());
        TemplateVariable instantiated = variable.getInstantiatedTemplate();
        ArrayList scope = Lists.newArrayList((Object[])new TemplateVariable[]{instantiated});
        scope.addAll(defQuery.getParents(defQuery.filterRelationsWithTarget(Sets.newHashSet((Object[])new TemplateVariable[]{instantiated}))));
        return defQuery.findNonTemporalTemplateFactorWith(scope).orElseThrow(() -> new EnvironmentalDynamicsException(String.format("There is no template factor for template variable %s", variable.getInstantiatedTemplate().getEntityName())));
    }

    private GroundProbabilisticNetwork instantiateGroundNetwork(List<GroundProbabilisticModel> goundModels, List<LocalProbabilisticNetwork> localNetworks) {
        GroundProbabilisticNetwork network = MODEL_FACTORY.createGroundProbabilisticNetwork();
        network.getLocalModels().addAll(goundModels);
        network.getLocalProbabilisticModels().addAll(localNetworks);
        return network;
    }

    private String constructNameOf(TemplateVariable template, Set<EObject> appliedObjects) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.constructNameOf(Lists.newArrayList(appliedObjects)));
        builder.append("_");
        builder.append(template.getEntityName());
        builder.append("Instantiation");
        return builder.toString();
    }

    private String constructNameOf(GroundRandomVariable variable, TemplateFactor factor) {
        return this.concat(variable.getEntityName(), this.concat(factor.getEntityName(), "Instantiation"));
    }

    private String constructNameOf(List<EObject> appliedObjects) {
        EObject any = appliedObjects.get(0);
        return AnnotationHandler.getTaggedId(any, AnnotationHandler.getInstantiationTag(any));
    }

    private String concat(String string1, String string2) {
        return string1.concat("_").concat(string2);
    }
}

