/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.generator.annotation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.emfprofile.Stereotype;
import org.palladiosimulator.envdyn.api.generator.annotation.InstantiationContext;
import org.palladiosimulator.envdyn.api.util.AnnotationHandler;
import org.palladiosimulator.envdyn.environment.templatevariable.Argument;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableGroup;

public class InstantiationContextProvider {
    protected static AnnotationHandler ANNOTATION_HANDLER;
    private final Map<String, ResolvedInstantiationContext> instantiationContexts = Maps.newHashMap();

    public InstantiationContextProvider(TemplateVariableDefinitions definitions) {
        ANNOTATION_HANDLER = new AnnotationHandler(definitions);
    }

    public Set<String> getInstantiationTags() {
        return this.instantiationContexts.keySet();
    }

    public ResolvedInstantiationContext getInstantiationContextsOf(String tag) {
        return Optional.ofNullable(this.instantiationContexts.get(tag)).orElse(ResolvedInstantiationContext.empty());
    }

    public void resolve(ResourceSet appliedModels) {
        this.resolveInstantiationContexts(AnnotationHandler.filterAnnotated(appliedModels));
    }

    private void resolveInstantiationContexts(List<EObject> appliedElements) {
        this.toGroupedInstantiationContexts(appliedElements).forEach(this::resolveInstantationContexts);
    }

    private Map<String, List<InstantiationContext>> toGroupedInstantiationContexts(List<EObject> appliedElements) {
        return this.toInstantiationContexts(appliedElements).stream().collect(Collectors.groupingBy(InstantiationContext::getTagId));
    }

    private Set<InstantiationContext> toInstantiationContexts(List<EObject> appliedElements) {
        return appliedElements.stream().map(this::toInstantiationContext).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private InstantiationContext toInstantiationContext(EObject appliedElement) {
        return this.createInstantiationContext(AnnotationHandler.getInstantiationTag(appliedElement), appliedElement);
    }

    private InstantiationContext createInstantiationContext(Stereotype instantiationTag, EObject appliedElement) {
        return new InstantiationContext(instantiationTag, appliedElement);
    }

    private void resolveInstantationContexts(String tag, List<InstantiationContext> contexts) {
        ResolvedInstantiationContext context = ResolvedInstantiationContext.create(tag, Sets.newLinkedHashSet(contexts));
        context.resolve();
        this.addResolvedInstantiationContext(tag, context);
    }

    private void addResolvedInstantiationContext(String tag, ResolvedInstantiationContext resolved) {
        this.instantiationContexts.put(tag, resolved);
    }

    public static class ResolvedInstantiationContext {
        private final Set<InstantiationContext> instantiationContexts;
        private final Set<TemplateVariable> instantiatedtemplates;

        private ResolvedInstantiationContext() {
            this.instantiationContexts = Sets.newLinkedHashSet();
            this.instantiatedtemplates = Sets.newLinkedHashSet();
        }

        private ResolvedInstantiationContext(String tag, Set<InstantiationContext> instantiationContexts) {
            this.instantiationContexts = instantiationContexts;
            this.instantiatedtemplates = this.getCommonTemplateStructure(instantiationContexts);
        }

        public static ResolvedInstantiationContext create(String tag, Set<InstantiationContext> instantiationContexts) {
            return new ResolvedInstantiationContext(tag, instantiationContexts);
        }

        public static ResolvedInstantiationContext empty() {
            return new ResolvedInstantiationContext();
        }

        public Set<TemplateVariable> getInstantiatedTemplates() {
            return this.instantiatedtemplates;
        }

        public void resolve() {
            for (TemplateVariable eachTemplate : this.instantiatedtemplates) {
                for (InstantiationContext eachContext : this.instantiationContexts) {
                    if (!eachContext.signaturesIntersect(eachTemplate)) continue;
                    eachContext.toInstantiate(eachTemplate);
                }
            }
        }

        public boolean singleInstantiation(TemplateVariable template) {
            if (template.isShared()) {
                return true;
            }
            return this.nonMultiInstantiation(template);
        }

        public Set<EObject> filterElementsInstantiating(TemplateVariable template) {
            return this.filterContextsIncluding(template).stream().map(InstantiationContext::getAppliedObject).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public Set<InstantiationContext> filterContextsIncluding(TemplateVariable template) {
            return this.instantiationContexts.stream().filter(this.contextsInstantiating(template)).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        private Predicate<InstantiationContext> contextsInstantiating(TemplateVariable template) {
            return c -> this.contains(template, c.getTemplates());
        }

        private boolean contains(TemplateVariable template, Set<TemplateVariable> templates) {
            return templates.stream().anyMatch(t -> t.getId().equals(template.getId()));
        }

        private boolean nonMultiInstantiation(TemplateVariable template) {
            Map<Argument, List<InstantiationContext>> instantiationCluster = this.filterContextsIncluding(template).stream().collect(Collectors.groupingBy(InstantiationContext::getArgument));
            return instantiationCluster.values().stream().allMatch(contexts -> contexts.size() == 1);
        }

        private Set<TemplateVariable> getCommonTemplateStructure(Set<InstantiationContext> contexts) {
            ArrayList result = Lists.newArrayList();
            InstantiationContext dummyContext = (InstantiationContext)Lists.newArrayList(contexts).get(0);
            EObject dummyElement = dummyContext.getAppliedObject();
            Optional<TemplateVariableGroup> group = ANNOTATION_HANDLER.getTemplateGroup(dummyContext.getStereotype(), dummyElement);
            if (group.isPresent()) {
                EcoreUtil.resolveAll((EObject)((EObject)group.get()));
                result.addAll(group.get().getGroupedTemplates());
            } else {
                result.add(ANNOTATION_HANDLER.getTemplate(dummyContext.getStereotype(), dummyElement).get());
            }
            return Sets.newLinkedHashSet((Iterable)result);
        }
    }
}

