/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.palladiosimulator.envdyn.api.exception.EnvironmentalDynamicsException;
import org.palladiosimulator.envdyn.api.util.TemplateDefinitionsQuerying;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicBehaviourExtension;
import org.palladiosimulator.envdyn.environment.dynamicmodel.InductiveDynamicBehaviour;
import org.palladiosimulator.envdyn.environment.dynamicmodel.InterTimeSliceInduction;
import org.palladiosimulator.envdyn.environment.dynamicmodel.IntraTimeSliceInduction;
import org.palladiosimulator.envdyn.environment.dynamicmodel.TimeSliceInduction;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.PersistenceRelation;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemporalRelation;
import org.palladiosimulator.envdyn.environment.templatevariable.TimeSliceRelation;

public class InductiveDynamicBehaviourQuerying {
    private final InductiveDynamicBehaviour dynamics;

    private InductiveDynamicBehaviourQuerying(InductiveDynamicBehaviour dynamics) {
        this.dynamics = dynamics;
    }

    private InductiveDynamicBehaviourQuerying(DynamicBehaviourExtension dynamics) {
        if (!InductiveDynamicBehaviour.class.isInstance(dynamics.getBehaviour())) {
            throw new EnvironmentalDynamicsException("Only inductive dynamic behaviour extensions are supported.");
        }
        this.dynamics = (InductiveDynamicBehaviour)InductiveDynamicBehaviour.class.cast(dynamics.getBehaviour());
    }

    public static InductiveDynamicBehaviourQuerying create(DynamicBehaviourExtension dynamics) {
        return new InductiveDynamicBehaviourQuerying(dynamics);
    }

    public Set<InterTimeSliceInduction> getInterTimeSliceInductions() {
        return this.dynamics.getTimeSliceInductions().stream().filter(InterTimeSliceInduction.class::isInstance).map(InterTimeSliceInduction.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<IntraTimeSliceInduction> getIntraTimeSliceInductions() {
        return this.dynamics.getTimeSliceInductions().stream().filter(IntraTimeSliceInduction.class::isInstance).map(IntraTimeSliceInduction.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<TemplateVariable> filterInterfaceVariables() {
        return this.getTemporalRelations().stream().map(InductiveDynamicBehaviourQuerying::getSource).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static List<TemplateVariable> deriveScopeFrom(InterTimeSliceInduction induction) {
        ArrayList result = Lists.newArrayList();
        for (TemporalRelation each : induction.getTemporalStructure()) {
            TemplateVariable candidate = InductiveDynamicBehaviourQuerying.getSource(each);
            if (TemplateDefinitionsQuerying.containsNot(candidate, result)) {
                result.add(candidate);
            }
            if (!TemplateDefinitionsQuerying.containsNot(candidate = InductiveDynamicBehaviourQuerying.getTarget(each), result)) continue;
            result.add(candidate);
        }
        return result;
    }

    public Optional<TimeSliceInduction> findInductionExtending(GroundRandomVariable variable) {
        return this.dynamics.getTimeSliceInductions().stream().filter(this.isExtensionOf(variable)).findFirst();
    }

    private Predicate<TimeSliceInduction> isExtensionOf(GroundRandomVariable variable) {
        return i -> i.getAppliedGroundVariable().getId().equals(variable.getId());
    }

    public static TemplateVariable getTarget(TemporalRelation relation) {
        if (PersistenceRelation.class.isInstance(relation)) {
            return ((PersistenceRelation)PersistenceRelation.class.cast(relation)).getInterfaceVariable();
        }
        return ((TimeSliceRelation)TimeSliceRelation.class.cast(relation)).getTarget();
    }

    public static TemplateVariable getSource(TemporalRelation relation) {
        if (PersistenceRelation.class.isInstance(relation)) {
            return ((PersistenceRelation)PersistenceRelation.class.cast(relation)).getInterfaceVariable();
        }
        return ((TimeSliceRelation)TimeSliceRelation.class.cast(relation)).getSource();
    }

    private Set<TemporalRelation> getTemporalRelations() {
        return this.dynamics.getTimeSliceInductions().stream().filter(InterTimeSliceInduction.class::isInstance).map(InterTimeSliceInduction.class::cast).flatMap(each -> each.getTemporalStructure().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

