/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.envdyn.api.entity.bn.BayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.exception.EnvironmentalDynamicsException;
import org.palladiosimulator.envdyn.api.generator.BayesianNetworkGenerator;
import org.palladiosimulator.envdyn.api.generator.ProbabilisticNetworkGenerator;
import org.palladiosimulator.envdyn.api.util.InductiveDynamicBehaviourQuerying;
import org.palladiosimulator.envdyn.api.util.TemplateDefinitionsQuerying;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicBehaviour;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicBehaviourExtension;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicBehaviourRepository;
import org.palladiosimulator.envdyn.environment.dynamicmodel.DynamicmodelFactory;
import org.palladiosimulator.envdyn.environment.dynamicmodel.InductiveDynamicBehaviour;
import org.palladiosimulator.envdyn.environment.dynamicmodel.InterTimeSliceInduction;
import org.palladiosimulator.envdyn.environment.dynamicmodel.TemporalDynamic;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.templatevariable.Relation;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateFactor;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;
import org.palladiosimulator.envdyn.environment.templatevariable.TemporalRelation;
import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.distributiontype.DistributiontypeFactory;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionType;

public class DynamicBayesianNetworkGenerator<I extends Value<?>>
extends ProbabilisticNetworkGenerator<DynamicBayesianNetwork<I>, I> {
    private static final String DBN_PREFIX = "DynamicBayesianNetwork";
    private static final String REPO_NAME = "TmpRepo";
    private static final DynamicmodelFactory FACTORY = DynamicmodelFactory.eINSTANCE;

    public DynamicBayesianNetworkGenerator(TemplateVariableDefinitions definitions) {
        super(definitions);
    }

    @Override
    public DynamicBayesianNetwork<I> createProbabilisticNetwork(GroundProbabilisticNetwork network, IProbabilityDistributionFactory<I> probabilityDistributionFactory) {
        BayesianNetworkGenerator bayesianNetworkGenerator = new BayesianNetworkGenerator(this.definitions);
        Object initial = bayesianNetworkGenerator.createProbabilisticNetwork(network, (IProbabilityDistributionFactory)probabilityDistributionFactory);
        DynamicBehaviourExtension extension = this.createDynamicBehaviourExtensionAndRepo((BayesianNetwork<I>)initial);
        return new DynamicBayesianNetwork<I>(this.createDistributionSkeleton(extension), initial, extension, probabilityDistributionFactory);
    }

    private DynamicBehaviourExtension createDynamicBehaviourExtensionAndRepo(BayesianNetwork<I> initial) {
        DynamicBehaviourRepository dynRepo = FACTORY.createDynamicBehaviourRepository();
        dynRepo.setEntityName(REPO_NAME);
        DynamicBehaviourExtension dynamics = this.createDynamicBehaviourExtension(initial);
        dynRepo.getExtensions().add((Object)dynamics);
        return dynamics;
    }

    private DynamicBehaviourExtension createDynamicBehaviourExtension(BayesianNetwork<I> initial) {
        DynamicBehaviourExtension extension = FACTORY.createDynamicBehaviourExtension();
        extension.setModel(initial.get());
        extension.setBehaviour(this.createInductiveDynamics(initial));
        return extension;
    }

    private DynamicBehaviour createInductiveDynamics(BayesianNetwork<I> initial) {
        InductiveDynamicBehaviour dynamics = FACTORY.createInductiveDynamicBehaviour();
        for (LocalProbabilisticNetwork eachLocal : initial.getLocalProbabilisticNetworks()) {
            for (InterTimeSliceInduction eachInduction : this.createInterTimeSliceInductions(eachLocal)) {
                TemporalDynamic dynamic = this.createTemporalDynamic(eachInduction, eachLocal);
                eachInduction.setDescriptiveModel(dynamic);
                dynamics.getLocalModels().add((Object)dynamic);
                dynamics.getTimeSliceInductions().add((Object)eachInduction);
            }
        }
        return dynamics;
    }

    private Set<InterTimeSliceInduction> createInterTimeSliceInductions(LocalProbabilisticNetwork localNetwork) {
        TemplateDefinitionsQuerying defQuery = this.createDefinitionQuerying(localNetwork);
        return localNetwork.getGroundRandomVariables().stream().map(v -> this.createInterTimeSliceInductions((GroundRandomVariable)v, defQuery)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Optional<InterTimeSliceInduction> createInterTimeSliceInductions(GroundRandomVariable variable, TemplateDefinitionsQuerying defQuery) {
        Set<TemporalRelation> temporalStructure = defQuery.filterTemporalRelationsWithTarget(variable.getInstantiatedTemplate());
        if (temporalStructure.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.createInterTimeSliceInduction(variable, temporalStructure));
    }

    private InterTimeSliceInduction createInterTimeSliceInduction(GroundRandomVariable appliedVariable, Set<TemporalRelation> temporalStructure) {
        InterTimeSliceInduction induction = FACTORY.createInterTimeSliceInduction();
        induction.setAppliedGroundVariable(appliedVariable);
        induction.getTemporalStructure().addAll(temporalStructure);
        return induction;
    }

    private TemporalDynamic createTemporalDynamic(InterTimeSliceInduction induction, LocalProbabilisticNetwork localNetwork) {
        TemplateFactor temporalFactor = this.createDefinitionQuerying(localNetwork).findTemporalTemplateFactorWith(InductiveDynamicBehaviourQuerying.deriveScopeFrom(induction)).orElseThrow(() -> new EnvironmentalDynamicsException("There is no scope defined."));
        return this.createLocalDynamicModel(temporalFactor, induction.getAppliedGroundVariable());
    }

    private TemporalDynamic createLocalDynamicModel(TemplateFactor temporalFactor, GroundRandomVariable variable) {
        TemporalDynamic dynamic = FACTORY.createTemporalDynamic();
        dynamic.setEntityName(String.format("%s_Temporal", variable.getEntityName()));
        dynamic.setInstantiatedFactor(temporalFactor);
        return dynamic;
    }

    private TemplateDefinitionsQuerying createDefinitionQuerying(LocalProbabilisticNetwork localNetwork) {
        Set<TemplateVariable> templateScope = BayesianNetwork.getTemplates(localNetwork);
        Set<Relation> relationScope = this.getRelations(templateScope);
        return TemplateDefinitionsQuerying.withScope(relationScope, templateScope);
    }

    private Set<Relation> getRelations(Set<TemplateVariable> templateScope) {
        EObject defs = ((TemplateVariable)Lists.newArrayList(templateScope).get(0)).eContainer();
        return Sets.newLinkedHashSet((Iterable)((TemplateVariableDefinitions)TemplateVariableDefinitions.class.cast(defs)).getRelation());
    }

    private ProbabilityDistributionSkeleton createDistributionSkeleton(DynamicBehaviourExtension dynamics) {
        ProbabilityDistributionSkeleton skeleton = DistributiontypeFactory.eINSTANCE.createProbabilityDistributionSkeleton();
        skeleton.setEntityName(String.format("%s1_%2s", DBN_PREFIX, dynamics.getEntityName()));
        skeleton.setType(ProbabilityDistributionType.DISCRETE);
        return skeleton;
    }
}

