/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.generator.annotation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.emfprofile.Stereotype;
import org.palladiosimulator.envdyn.api.exception.EnvironmentalDynamicsException;
import org.palladiosimulator.envdyn.api.generator.annotation.InstantiationContextProvider;
import org.palladiosimulator.envdyn.api.util.AnnotationHandler;
import org.palladiosimulator.envdyn.environment.templatevariable.Argument;
import org.palladiosimulator.envdyn.environment.templatevariable.LogicalVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;

public class InstantiationContext {
    private final String id;
    private final Stereotype tag;
    private final Argument argument;
    private final EObject appliedObject;
    private final Set<TemplateVariable> instantiatedTemplates;

    public InstantiationContext(Stereotype tag, EObject appliedObject) {
        this.id = AnnotationHandler.getTaggedId(appliedObject, tag);
        this.tag = tag;
        this.argument = InstantiationContextProvider.ANNOTATION_HANDLER.getArgument(appliedObject, tag).orElseThrow(() -> new EnvironmentalDynamicsException("There is no argument specified."));
        this.appliedObject = appliedObject;
        this.instantiatedTemplates = Sets.newLinkedHashSet();
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getTagId() {
        return this.id;
    }

    public Stereotype getStereotype() {
        return this.tag;
    }

    public Set<TemplateVariable> getTemplates() {
        return this.instantiatedTemplates;
    }

    public void toInstantiate(TemplateVariable template) {
        this.instantiatedTemplates.add(template);
    }

    public EObject getAppliedObject() {
        return this.appliedObject;
    }

    public boolean signatureMatches(TemplateVariable template) {
        List<Argument> signature = this.signatureAsArgs(template);
        if (signature.size() > 1) {
            return false;
        }
        return this.isIncluded(this.getArgument(), signature);
    }

    public boolean signaturesIntersect(TemplateVariable template) {
        return this.signaturesIntersect(this.signatureAsArgs(template));
    }

    public boolean signaturesIntersect(List<Argument> signature) {
        return this.isIncluded(this.getArgument(), signature);
    }

    private List<Argument> signatureAsArgs(TemplateVariable template) {
        ArrayList argSignature = Lists.newArrayList();
        Optional.ofNullable(template.getRefines()).ifPresent(t -> {
            boolean bl = argSignature.addAll(this.signatureAsArgs((TemplateVariable)t));
        });
        for (LogicalVariable each : template.getSignature()) {
            argSignature.add(each.getArgument());
        }
        return argSignature;
    }

    private boolean isIncluded(Argument arg, List<Argument> signature) {
        return signature.stream().anyMatch(this.equalArgs(arg));
    }

    private Predicate<Argument> equalArgs(Argument argToCheck) {
        return arg -> arg.getId().equals(argToCheck.getId());
    }
}

