/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.api.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.envdyn.api.exception.EnvironmentalDynamicsException;
import org.palladiosimulator.envdyn.api.util.InductiveDynamicBehaviourQuerying;
import org.palladiosimulator.envdyn.environment.templatevariable.DependenceRelation;
import org.palladiosimulator.envdyn.environment.templatevariable.PersistenceRelation;
import org.palladiosimulator.envdyn.environment.templatevariable.Relation;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateFactor;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;
import org.palladiosimulator.envdyn.environment.templatevariable.TemporalRelation;
import tools.mdsd.modelingfoundations.identifier.Identifier;

public class TemplateDefinitionsQuerying {
    private final QueryingScope scope;
    private final TemplateVariableDefinitions definitions;

    private TemplateDefinitionsQuerying(Collection<Relation> relationScope, Collection<TemplateVariable> templateScope, TemplateVariableDefinitions defintions) {
        this.scope = new QueryingScope(relationScope, templateScope);
        this.definitions = defintions;
    }

    private TemplateDefinitionsQuerying(TemplateVariableDefinitions defintions) {
        this.scope = new QueryingScope(defintions);
        this.definitions = defintions;
    }

    public static TemplateDefinitionsQuerying withBaseTemplatesOnly(TemplateVariableDefinitions definitions) {
        return new TemplateDefinitionsQuerying(definitions);
    }

    public static TemplateDefinitionsQuerying withScope(Set<Relation> relationScope, Set<TemplateVariable> templateScope) {
        return new TemplateDefinitionsQuerying(relationScope, templateScope, TemplateDefinitionsQuerying.getTemplateVariableDefinitions(templateScope));
    }

    public static TemplateDefinitionsQuerying withTemplateScope(Set<TemplateVariable> templateScope) {
        TemplateVariableDefinitions definitions = TemplateDefinitionsQuerying.getTemplateVariableDefinitions(templateScope);
        LinkedHashSet dRelations = Sets.newLinkedHashSet();
        for (Relation each : TemplateDefinitionsQuerying.filterDependenceRelations(definitions)) {
            DependenceRelation dRelation = (DependenceRelation)each;
            if (!Boolean.logicalOr(TemplateDefinitionsQuerying.contains(dRelation.getSource(), templateScope), TemplateDefinitionsQuerying.contains(dRelation.getTarget(), templateScope))) continue;
            dRelations.add(dRelation);
        }
        return new TemplateDefinitionsQuerying(dRelations, templateScope, definitions);
    }

    public static boolean contains(TemplateVariable template, Collection<TemplateVariable> templates) {
        return templates.stream().anyMatch(t -> TemplateDefinitionsQuerying.areEqual(template, t));
    }

    public static boolean containsNot(TemplateVariable template, Collection<TemplateVariable> templates) {
        return templates.stream().noneMatch(t -> TemplateDefinitionsQuerying.areEqual(template, t));
    }

    public static boolean areEqual(TemplateVariable var1, TemplateVariable var2) {
        return var1.getId().equals(var2.getId());
    }

    public static boolean areNotEqual(TemplateVariable var1, TemplateVariable var2) {
        return !TemplateDefinitionsQuerying.areEqual(var1, var2);
    }

    public Set<TemporalRelation> filterTemporalRelationsWithSource(TemplateVariable interfaceVariable) {
        return this.filterTemporalRelations().stream().filter(this.hasTemporalSource(interfaceVariable)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<TemporalRelation> filterTemporalRelationsWithTarget(TemplateVariable interfaceVariable) {
        return this.filterTemporalRelations().stream().filter(this.hasTemporalTarget(interfaceVariable)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Predicate<TemporalRelation> hasTemporalSource(TemplateVariable interfaceVariable) {
        return r -> TemplateDefinitionsQuerying.areEqual(InductiveDynamicBehaviourQuerying.getSource(r), interfaceVariable);
    }

    private Predicate<TemporalRelation> hasTemporalTarget(TemplateVariable interfaceVariable) {
        return r -> TemplateDefinitionsQuerying.areEqual(InductiveDynamicBehaviourQuerying.getTarget(r), interfaceVariable);
    }

    public Set<TemplateVariable> filterInterfaceVariables() {
        return this.filterTemporalRelations().stream().map(r -> InductiveDynamicBehaviourQuerying.getSource(r)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<TemplateVariable> getTemplateVariables() {
        return this.scope.getTemplates().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Optional<TemplateFactor> findTemporalTemplateFactorWith(List<TemplateVariable> scope) {
        return this.getTemplateFactors().filter(this.withSameScope(scope).and(this.isTemporal())).findFirst();
    }

    public Optional<TemplateFactor> findNonTemporalTemplateFactorWith(List<TemplateVariable> scope) {
        return this.getTemplateFactors().filter(this.withSameScope(scope).and(this.isNonTemporal())).findFirst();
    }

    private Predicate<TemplateFactor> isTemporal() {
        return TemplateFactor::isTemporal;
    }

    private Predicate<TemplateFactor> isNonTemporal() {
        return this.isTemporal().negate();
    }

    private static TemplateVariableDefinitions getTemplateVariableDefinitions(Set<TemplateVariable> templateScope) {
        Iterator<TemplateVariable> iterator = templateScope.iterator();
        if (iterator.hasNext()) {
            return (TemplateVariableDefinitions)iterator.next().eContainer();
        }
        return null;
    }

    private Predicate<TemplateFactor> withSameScope(List<TemplateVariable> scope) {
        return factor -> {
            if (scope.size() != factor.getScope().size()) {
                return false;
            }
            Set<String> givenScope = this.asIds(scope);
            Set<String> factorScope = this.asIds((List<TemplateVariable>)factor.getScope());
            return Sets.difference(givenScope, factorScope).isEmpty();
        };
    }

    private Set<String> asIds(List<TemplateVariable> templates) {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        for (TemplateVariable each : templates) {
            ids.add(each.getId());
        }
        return ids;
    }

    public Set<TemplateVariable> getParents(Set<DependenceRelation> dependenceStructure) {
        Set interimResult = dependenceStructure.stream().map(DependenceRelation::getSource).collect(Collectors.toCollection(LinkedHashSet::new));
        return this.scope.adjustToScope(interimResult);
    }

    public Set<TemplateVariable> filterAllChildsOf(Set<TemplateVariable> templates) {
        return templates.stream().flatMap(t -> this.filterAllChildsOf((TemplateVariable)t).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<TemplateVariable> filterAllParentsOf(TemplateVariable template) {
        return this.scope.getTemplates().filter(this.parentsOf(template)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<TemplateVariable> filterAllChildsOf(TemplateVariable template) {
        return this.scope.getTemplates().filter(this.childsOf(template)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Predicate<TemplateVariable> parentsOf(TemplateVariable template) {
        return t -> this.filterDependenceRelations().stream().anyMatch(this.hasRelation((TemplateVariable)t, template));
    }

    private Predicate<TemplateVariable> childsOf(TemplateVariable template) {
        return t -> this.filterDependenceRelations().stream().anyMatch(this.hasRelation(template, (TemplateVariable)t));
    }

    private Predicate<DependenceRelation> hasRelation(TemplateVariable source, TemplateVariable target) {
        return r -> r.getSource().getId().equals(source.getId()) && r.getTarget().getId().equals(target.getId());
    }

    public boolean relationExist(TemplateVariable source, TemplateVariable target) {
        return this.findRelation(source, target).isPresent();
    }

    public Set<TemplateVariable> filterChildless() {
        return this.scope.getTemplates().filter(this.variablesWithoutChild()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<TemplateVariable> filterParentless() {
        return this.scope.getTemplates().filter(this.variablesWithoutParent()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Predicate<TemplateVariable> variablesWithoutParent() {
        return t -> this.filterDependenceRelations().stream().noneMatch(r -> r.getTarget().getId().equals(t.getId()));
    }

    private Predicate<TemplateVariable> variablesWithoutChild() {
        return t -> this.filterDependenceRelations().stream().noneMatch(r -> r.getSource().getId().equals(t.getId()));
    }

    public Optional<DependenceRelation> findRelation(TemplateVariable source, TemplateVariable target) {
        return this.filterDependenceRelations().stream().filter(this.hasSource(source).and(this.hasTarget(target))).findFirst();
    }

    public Set<DependenceRelation> filterRelationsWithSource(Set<TemplateVariable> templates) {
        return this.filterDependenceRelations().stream().filter(this.withSource(templates)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<DependenceRelation> filterRelationsWithTarget(Set<TemplateVariable> templates) {
        return this.filterDependenceRelations().stream().filter(this.withTarget(templates)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Predicate<DependenceRelation> withSource(Set<TemplateVariable> templates) {
        return r -> templates.stream().anyMatch(t -> this.hasSource((TemplateVariable)t).test((DependenceRelation)r));
    }

    private Predicate<DependenceRelation> withTarget(Set<TemplateVariable> templates) {
        return r -> templates.stream().anyMatch(t -> this.hasTarget((TemplateVariable)t).test((DependenceRelation)r));
    }

    private Predicate<DependenceRelation> hasSource(TemplateVariable template) {
        return r -> TemplateDefinitionsQuerying.areEqual(template, r.getSource());
    }

    private Predicate<DependenceRelation> hasTarget(TemplateVariable template) {
        return r -> TemplateDefinitionsQuerying.areEqual(template, r.getTarget());
    }

    private Set<DependenceRelation> filterDependenceRelations() {
        return this.scope.getRelations().filter(DependenceRelation.class::isInstance).map(DependenceRelation.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<TemporalRelation> filterTemporalRelations() {
        return this.scope.getRelations().filter(TemporalRelation.class::isInstance).map(TemporalRelation.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<TemplateFactor> getTemplateFactors() {
        if (this.definitions == null) {
            return Stream.empty();
        }
        return this.definitions.getFactors().stream();
    }

    private static Set<Relation> filterDependenceRelations(TemplateVariableDefinitions definitions) {
        if (definitions == null) {
            return Sets.newLinkedHashSet();
        }
        return definitions.getRelation().stream().filter(DependenceRelation.class::isInstance).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private class QueryingScope {
        private final Set<Relation> relationScope;
        private final Set<TemplateVariable> templateScope;

        public QueryingScope(TemplateVariableDefinitions definitions) {
            this.relationScope = Sets.newLinkedHashSet((Iterable)definitions.getRelation());
            this.templateScope = this.resolveBaseTemplates((List<TemplateVariable>)definitions.getVariables());
        }

        public QueryingScope(Collection<Relation> relationScope, Collection<TemplateVariable> templateScope) {
            this.relationScope = Sets.newLinkedHashSet(relationScope);
            this.templateScope = Sets.newLinkedHashSet(templateScope);
            this.checkValidity();
            this.adjustScope();
        }

        public Stream<Relation> getRelations() {
            return this.relationScope.stream();
        }

        public Stream<TemplateVariable> getTemplates() {
            return this.templateScope.stream();
        }

        public Set<TemplateVariable> adjustToScope(Set<TemplateVariable> templates) {
            for (TemplateVariable each : templates) {
                if (!TemplateDefinitionsQuerying.containsNot(each, this.templateScope)) continue;
                templates.remove(each);
                templates.add(this.findTemplateInScope(each));
            }
            return templates;
        }

        private void checkValidity() {
            Map<String, List<TemplateVariable>> baseTemplates = this.getTemplates().collect(Collectors.groupingBy(Identifier::getId));
            for (String each : baseTemplates.keySet()) {
                if (baseTemplates.get(each).size() <= 1) continue;
                throw new EnvironmentalDynamicsException("It is required that only one of the templates in the refined template hierarchy is in the scope");
            }
        }

        private void adjustScope() {
            for (TemplateVariable each : this.templateScope) {
                TemplateVariable base;
                if (!TemplateDefinitionsQuerying.areNotEqual(each, base = this.resolveBaseTemplate(each))) continue;
                this.adjustRelationScope(base, each);
            }
        }

        private Set<TemplateVariable> resolveBaseTemplates(List<TemplateVariable> templates) {
            LinkedHashSet baseTemplates = Sets.newLinkedHashSet();
            for (TemplateVariable each : templates) {
                TemplateVariable base;
                if (!TemplateDefinitionsQuerying.areEqual(each, base = this.resolveBaseTemplate(each))) continue;
                baseTemplates.add(each);
            }
            return baseTemplates;
        }

        private TemplateVariable resolveBaseTemplate(TemplateVariable template) {
            return template.getRefines() != null ? this.resolveBaseTemplate(template.getRefines()) : template;
        }

        private void adjustRelationScope(TemplateVariable base, TemplateVariable sub) {
            for (Relation each : Sets.newLinkedHashSet(this.relationScope)) {
                if (each instanceof DependenceRelation) {
                    this.adjustDependenceRelation(base, sub, (DependenceRelation)each);
                    continue;
                }
                if (!(each instanceof PersistenceRelation)) continue;
                this.adjustPersistenceRelation(base, sub, (PersistenceRelation)each);
            }
        }

        private void adjustPersistenceRelation(TemplateVariable base, TemplateVariable sub, PersistenceRelation relation) {
            if (TemplateDefinitionsQuerying.areEqual(relation.getInterfaceVariable(), base)) {
                this.relationScope.add(this.copyAndAdjust(relation, sub));
            }
        }

        private void adjustDependenceRelation(TemplateVariable base, TemplateVariable sub, DependenceRelation relation) {
            if (TemplateDefinitionsQuerying.areEqual(relation.getSource(), base)) {
                this.relationScope.remove(relation);
                this.relationScope.add(this.copyAndAdjustSource(relation, sub));
            } else if (TemplateDefinitionsQuerying.areEqual(relation.getTarget(), base)) {
                this.relationScope.remove(relation);
                this.relationScope.add(this.copyAndAdjustTarget(relation, sub));
            }
        }

        private Relation copyAndAdjust(PersistenceRelation relation, TemplateVariable sub) {
            PersistenceRelation adjustedCopy = (PersistenceRelation)EcoreUtil.copy((EObject)relation);
            adjustedCopy.setInterfaceVariable(sub);
            return adjustedCopy;
        }

        private Relation copyAndAdjustSource(DependenceRelation relation, TemplateVariable sub) {
            DependenceRelation adjustedCopy = (DependenceRelation)EcoreUtil.copy((EObject)relation);
            adjustedCopy.setSource(sub);
            return adjustedCopy;
        }

        private Relation copyAndAdjustTarget(DependenceRelation relation, TemplateVariable sub) {
            DependenceRelation adjustedCopy = (DependenceRelation)EcoreUtil.copy((EObject)relation);
            adjustedCopy.setTarget(sub);
            return adjustedCopy;
        }

        private TemplateVariable findTemplateInScope(TemplateVariable outOfScopeTemplate) {
            for (TemplateVariable each : this.templateScope) {
                if (!TemplateDefinitionsQuerying.areEqual(this.resolveBaseTemplate(each), this.resolveBaseTemplate(outOfScopeTemplate))) continue;
                return each;
            }
            throw new EnvironmentalDynamicsException(String.format("Template variable %s is not in the queried scope.", outOfScopeTemplate.getEntityName()));
        }
    }
}

