/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.envdyn.environment.templatevariable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DependenceType implements Enumerator
{
    DIRECTED(0, "DIRECTED", "DIRECTED"),
    UNDIRECTED(1, "UNDIRECTED", "UNDIRECTED");

    public static final int DIRECTED_VALUE = 0;
    public static final int UNDIRECTED_VALUE = 1;
    private static final DependenceType[] VALUES_ARRAY;
    public static final List<DependenceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DependenceType[]{DIRECTED, UNDIRECTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DependenceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependenceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependenceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependenceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependenceType get(int value) {
        switch (value) {
            case 0: {
                return DIRECTED;
            }
            case 1: {
                return UNDIRECTED;
            }
        }
        return null;
    }

    private DependenceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

