/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application;

import de.uka.ipd.sdq.workflow.BlackboardBasedWorkflow;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.palladiosimulator.experimentautomation.application.Activator;
import org.palladiosimulator.experimentautomation.application.config.ExperimentAutomationConfiguration;
import org.palladiosimulator.experimentautomation.application.jobs.RunExperimentAutomationJob;
import org.palladiosimulator.experimentautomation.application.utils.EcoreHelper;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.ExperimentRepository;
import org.palladiosimulator.experimentautomation.experiments.ExperimentsPackage;

public class ExperimentApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args.length < 1) {
            System.out.println("The mandatory parameters have not been specified.");
            return IApplication.EXIT_OK;
        }
        Path experimentsLocation = new Path(args[0]);
        ArrayList<String> filteredExperimentIDs = new ArrayList<String>();
        if (args.length >= 2) {
            String[] ids;
            String[] stringArray = ids = args[1].split(";");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                filteredExperimentIDs.add(id);
                ++n2;
            }
        }
        List<Experiment> experiments = ExperimentApplication.getExperiments((IPath)experimentsLocation, filteredExperimentIDs);
        ExperimentAutomationConfiguration experimentAutomationConfiguration = new ExperimentAutomationConfiguration();
        experimentAutomationConfiguration.setExperiments(experiments);
        experimentAutomationConfiguration.setAttributes(new HashMap<String, Object>());
        MDSDBlackboard blackboard = new MDSDBlackboard();
        BlackboardBasedWorkflow workflow = new BlackboardBasedWorkflow((IJob)new RunExperimentAutomationJob(experimentAutomationConfiguration), (Blackboard)blackboard);
        workflow.run();
        return IApplication.EXIT_OK;
    }

    private static List<Experiment> getExperiments(IPath experimentsLocation, List<String> filteredExperimentIDs) {
        Object experiments;
        Bundle bundle = Activator.getDefault().getBundle();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EClass expectedType = ExperimentsPackage.eINSTANCE.getExperimentRepository();
        ExperimentRepository experimentRepository = (ExperimentRepository)EcoreHelper.loadResourceFromBundle((ResourceSet)resourceSet, bundle, experimentsLocation, expectedType);
        if (filteredExperimentIDs == null || filteredExperimentIDs.isEmpty()) {
            experiments = experimentRepository.getExperiments();
        } else {
            experiments = new ArrayList();
            block0: for (Experiment e : experimentRepository.getExperiments()) {
                for (String id : filteredExperimentIDs) {
                    if (!e.getId().equalsIgnoreCase(id)) continue;
                    experiments.add(e);
                    continue block0;
                }
            }
        }
        return experiments;
    }

    public void stop() {
    }
}

