/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.simulation.core.AbstractSimulationConfig;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.experimentautomation.application.VariationFactorTuple;
import org.palladiosimulator.experimentautomation.experiments.Experiment;

public class LogExperimentInformationJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(LogExperimentInformationJob.class);
    private final Experiment experiment;
    private final AbstractSimulationConfig simulationConfig;
    private final List<VariationFactorTuple> variationFactorTuples;
    private final int repetition;

    public LogExperimentInformationJob(Experiment experiment, AbstractSimulationConfig simulationConfig, List<VariationFactorTuple> variationFactorTuples, int repetition) {
        this.experiment = experiment;
        this.simulationConfig = simulationConfig;
        this.variationFactorTuples = variationFactorTuples;
        this.repetition = repetition;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("============= Experiment Automation: Experiment Run =============\n");
        stringBuilder.append("NAME: \"");
        stringBuilder.append(this.simulationConfig.getNameBase());
        stringBuilder.append("\"\n");
        for (VariationFactorTuple variationFactorTuple : this.variationFactorTuples) {
            stringBuilder.append("VARIATION: ");
            stringBuilder.append(variationFactorTuple.getVariation().getName());
            stringBuilder.append("[");
            stringBuilder.append(variationFactorTuple.getFactor());
            stringBuilder.append("](");
            stringBuilder.append(variationFactorTuple.getVariation().getVariedObjectId());
            stringBuilder.append(")\n");
        }
        stringBuilder.append("REPETITION: ");
        stringBuilder.append(String.valueOf(this.repetition));
        stringBuilder.append(" of ");
        stringBuilder.append(String.valueOf(this.experiment.getRepetitions()));
        stringBuilder.append("\n");
        stringBuilder.append("SIMULATOR ID: \"");
        stringBuilder.append(this.simulationConfig.getSimulatorId());
        stringBuilder.append("\"\n");
        stringBuilder.append("RECORDER: \"");
        stringBuilder.append(this.simulationConfig.getRecorderName());
        stringBuilder.append("\"\n");
        LOGGER.info((Object)stringBuilder.toString());
        super.execute(monitor);
    }
}

