/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.variation.valueprovider;

import org.palladiosimulator.experimentautomation.application.variation.valueprovider.ExponentialValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.IValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.LinearValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.NestedIntervalsDoubleValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.NestedIntervalsLongValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.PolynomialValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.SetValueProviderStrategy;
import org.palladiosimulator.experimentautomation.experiments.ExperimentsPackage;
import org.palladiosimulator.experimentautomation.experiments.ExponentialValueProvider;
import org.palladiosimulator.experimentautomation.experiments.LinearValueProvider;
import org.palladiosimulator.experimentautomation.experiments.NestedIntervalsDoubleValueProvider;
import org.palladiosimulator.experimentautomation.experiments.NestedIntervalsLongValueProvider;
import org.palladiosimulator.experimentautomation.experiments.PolynomialValueProvider;
import org.palladiosimulator.experimentautomation.experiments.SetValueProvider;
import org.palladiosimulator.experimentautomation.experiments.ValueProvider;

public class ValueProviderFactory {
    public static IValueProviderStrategy<Double> createDoubleValueProvider(ValueProvider specification) {
        if (ExperimentsPackage.eINSTANCE.getPolynomialValueProvider().isInstance((Object)specification)) {
            PolynomialValueProvider p = (PolynomialValueProvider)specification;
            return new PolynomialValueProviderStrategy(p);
        }
        if (ExperimentsPackage.eINSTANCE.getExponentialValueProvider().isInstance((Object)specification)) {
            ExponentialValueProvider p = (ExponentialValueProvider)specification;
            return new ExponentialValueProviderStrategy(p);
        }
        if (ExperimentsPackage.eINSTANCE.getSetValueProvider().isInstance((Object)specification)) {
            SetValueProvider p = (SetValueProvider)specification;
            return new SetValueProviderStrategy(p);
        }
        if (ExperimentsPackage.eINSTANCE.getLinearValueProvider().isInstance((Object)specification)) {
            LinearValueProvider p = (LinearValueProvider)specification;
            return new LinearValueProviderStrategy(p);
        }
        if (ExperimentsPackage.eINSTANCE.getNestedIntervalsDoubleValueProvider().isInstance((Object)specification)) {
            NestedIntervalsDoubleValueProvider p = (NestedIntervalsDoubleValueProvider)specification;
            return new NestedIntervalsDoubleValueProviderStrategy(p);
        }
        throw new RuntimeException("Could not find a double value provider strategy for " + specification.eClass().getName());
    }

    public static IValueProviderStrategy<Long> createLongValueProvider(ValueProvider specification) {
        if (ExperimentsPackage.eINSTANCE.getNestedIntervalsLongValueProvider().isInstance((Object)specification)) {
            NestedIntervalsLongValueProvider p = (NestedIntervalsLongValueProvider)specification;
            return new NestedIntervalsLongValueProviderStrategy(p);
        }
        throw new RuntimeException("Could not find a long value provider strategy for " + specification.eClass().getName());
    }
}

