/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.experimentautomation.experiments.InitialModel;

public class LoadModelsIntoBlackboardJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(LoadModelsIntoBlackboardJob.class);
    public static final String PCM_MODELS_ORIGINAL_PARTITION_ID = "org.palladiosimulator.pcmmodels.original.partition";
    private final InitialModel initialModel;
    private final boolean loadDefaultPcmModels;

    public LoadModelsIntoBlackboardJob(InitialModel initialModel, boolean loadModels) {
        super(false);
        this.initialModel = initialModel;
        this.loadDefaultPcmModels = loadModels;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ArrayList<EObject> pcmModels = new ArrayList<EObject>();
        if (this.loadDefaultPcmModels) {
            pcmModels.add((EObject)this.initialModel.getRepository());
            pcmModels.add((EObject)this.initialModel.getSystem());
            pcmModels.add((EObject)this.initialModel.getResourceEnvironment());
            pcmModels.add((EObject)this.initialModel.getAllocation());
            pcmModels.add((EObject)this.initialModel.getUsageModel());
            pcmModels.add((EObject)this.initialModel.getMiddlewareRepository());
            pcmModels.add((EObject)this.initialModel.getEventMiddleWareRepository());
        }
        pcmModels.add((EObject)this.initialModel.getUsageEvolution());
        pcmModels.add((EObject)this.initialModel.getMonitorRepository());
        this.loadIntoBlackboard(PCM_MODELS_ORIGINAL_PARTITION_ID, pcmModels);
        this.loadIntoBlackboard("org.palladiosimulator.pcmmodels.partition", pcmModels);
    }

    private void loadIntoBlackboard(String partitionId, List<EObject> eObjects) {
        ResourceSetPartition partition = (ResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition(partitionId);
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)("Loading models for partition " + partitionId));
        }
        for (EObject eObject : eObjects) {
            LoadModelsIntoBlackboardJob.loadIfExisting(partition, eObject);
        }
        partition.resolveAllProxies();
    }

    private static void loadIfExisting(ResourceSetPartition resourceSetPartition, EObject eObject) {
        if (eObject != null) {
            resourceSetPartition.loadModel(eObject.eResource().getURI());
        }
    }

    public String getName() {
        return "Perform AT PCM Model Load";
    }
}

