/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractSimulationConfiguration;
import org.palladiosimulator.experimentautomation.application.VariationFactorTuple;
import org.palladiosimulator.experimentautomation.application.jobs.VaryJob;
import org.palladiosimulator.experimentautomation.application.tooladapter.IToolAdapter;
import org.palladiosimulator.experimentautomation.application.tooladapter.RunAnalysisJob;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.AbstractNestedIntervalsValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.IValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.NestedIntervalsDoubleValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.NestedIntervalsLongValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.ValueProviderFactory;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.ToolConfiguration;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.core.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.edp2.EDP2RawRecorder;
import org.palladiosimulator.recorderframework.edp2.config.EDP2ReportRecorderConfigurationFactory;

public class AddDynamicVariationJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final Double EPSILON = 1.0E-5;
    private static final MeasuringpointFactory MEASURING_POINT_FACTORY = MeasuringpointFactory.eINSTANCE;
    private final IToolAdapter toolAdapter;
    private final Experiment experiment;
    private final AbstractSimulationConfiguration simulationConfiguration;
    private final List<VariationFactorTuple> variationFactorTuples;
    private final int repetition;
    private final Map<VariationFactorTuple, AbstractNestedIntervalsValueProviderStrategy> tuples2nestedIntervals;
    private static final MeasuringPointRepository MEASURING_POINT_REPOSITORY = MEASURING_POINT_FACTORY.createMeasuringPointRepository();
    private RunAnalysisJob runAnalysisJob;

    public AddDynamicVariationJob(RunAnalysisJob runAnalysisJob, IToolAdapter toolAdapter, Experiment experiment, AbstractSimulationConfiguration simulationConfiguration, List<VariationFactorTuple> variationFactorTuples, int repetition) {
        super(true);
        this.runAnalysisJob = runAnalysisJob;
        this.toolAdapter = toolAdapter;
        this.experiment = experiment;
        this.simulationConfiguration = simulationConfiguration;
        this.variationFactorTuples = variationFactorTuples;
        this.repetition = repetition;
        this.tuples2nestedIntervals = this.computeNestedIntervalsValueProviders();
    }

    private Map<VariationFactorTuple, AbstractNestedIntervalsValueProviderStrategy> computeNestedIntervalsValueProviders() {
        HashMap<VariationFactorTuple, AbstractNestedIntervalsValueProviderStrategy> result = new HashMap<VariationFactorTuple, AbstractNestedIntervalsValueProviderStrategy>();
        for (VariationFactorTuple variationFactorTuple : this.variationFactorTuples) {
            try {
                IValueProviderStrategy<Long> valueProvider = ValueProviderFactory.createLongValueProvider(variationFactorTuple.getVariation().getValueProvider());
                if (!(valueProvider instanceof NestedIntervalsLongValueProviderStrategy)) continue;
                NestedIntervalsLongValueProviderStrategy nestedInterval = (NestedIntervalsLongValueProviderStrategy)valueProvider;
                result.put(variationFactorTuple, nestedInterval);
            }
            catch (RuntimeException e) {
                IValueProviderStrategy<Double> valueProvider = ValueProviderFactory.createDoubleValueProvider(variationFactorTuple.getVariation().getValueProvider());
                if (!(valueProvider instanceof NestedIntervalsDoubleValueProviderStrategy)) continue;
                NestedIntervalsDoubleValueProviderStrategy nestedInterval = (NestedIntervalsDoubleValueProviderStrategy)valueProvider;
                result.put(variationFactorTuple, nestedInterval);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.tuples2nestedIntervals.size() <= 0) return;
        for (VariationFactorTuple variationFactorTuple : this.tuples2nestedIntervals.keySet()) {
            AbstractNestedIntervalsValueProviderStrategy nestedInterval = this.tuples2nestedIntervals.get(variationFactorTuple);
            if (this.runAnalysisJob.sloWasViolated()) {
                if (nestedInterval instanceof NestedIntervalsDoubleValueProviderStrategy) {
                    nestedInterval.setMax((Double)nestedInterval.valueAtPosition(0) - EPSILON);
                } else {
                    if (!(nestedInterval instanceof NestedIntervalsLongValueProviderStrategy)) throw new RuntimeException("Unknown nested intervals provider strategy");
                    nestedInterval.setMax((Long)nestedInterval.valueAtPosition(0) - 1L);
                }
            } else {
                nestedInterval.setMin(nestedInterval.valueAtPosition(0));
            }
            if (nestedInterval.isConverged()) {
                TupleMeasurement resultMeasurement;
                this.tuples2nestedIntervals.remove(variationFactorTuple);
                Map<String, Object> recorderConfigurationMap = this.runAnalysisJob.getConfiguration();
                Measure pointInTimeMeasure = Measure.valueOf((double)0.0, (Unit)SI.SECOND);
                ArrayList<BasicMeasurement> result = new ArrayList<BasicMeasurement>(2);
                result.add(new BasicMeasurement(pointInTimeMeasure, (BaseMetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC));
                if (nestedInterval instanceof NestedIntervalsDoubleValueProviderStrategy) {
                    capacityMeasure = Measure.valueOf((double)((Double)nestedInterval.valueAtPosition(0)), (Unit)SI.SECOND);
                    result.add(new BasicMeasurement(capacityMeasure, MetricDescriptionConstants.INTER_ARRIVAL_TIME_CAPACITY));
                    resultMeasurement = new TupleMeasurement(result, MetricDescriptionConstants.INTER_ARRIVAL_TIME_CAPACITY_TUPLE);
                    recorderConfigurationMap.put("recorderAcceptedMetric", MetricDescriptionConstants.INTER_ARRIVAL_TIME_CAPACITY_TUPLE);
                } else {
                    if (!(nestedInterval instanceof NestedIntervalsLongValueProviderStrategy)) throw new RuntimeException("Unknown nested intervals provider strategy");
                    capacityMeasure = Measure.valueOf((long)((Long)nestedInterval.valueAtPosition(0)), (Unit)Dimensionless.UNIT);
                    result.add(new BasicMeasurement(capacityMeasure, MetricDescriptionConstants.USER_CAPACITY));
                    resultMeasurement = new TupleMeasurement(result, MetricDescriptionConstants.USER_CAPACITY_TUPLE);
                    recorderConfigurationMap.put("recorderAcceptedMetric", MetricDescriptionConstants.USER_CAPACITY_TUPLE);
                }
                StringMeasuringPoint capacityMeasuringPoint = MEASURING_POINT_FACTORY.createStringMeasuringPoint();
                capacityMeasuringPoint.setMeasuringPoint("System Capacity");
                MEASURING_POINT_REPOSITORY.getMeasuringPoints().add((Object)capacityMeasuringPoint);
                capacityMeasuringPoint.setMeasuringPointRepository(MEASURING_POINT_REPOSITORY);
                recorderConfigurationMap.put("measuringPoint", capacityMeasuringPoint);
                EDP2ReportRecorderConfigurationFactory edp2ConfigFactory = new EDP2ReportRecorderConfigurationFactory();
                edp2ConfigFactory.initialize(recorderConfigurationMap);
                IRecorderConfiguration recorderConfiguration = edp2ConfigFactory.createRecorderConfiguration(recorderConfigurationMap);
                EDP2RawRecorder reportRecorder = new EDP2RawRecorder();
                reportRecorder.initialize(recorderConfiguration);
                reportRecorder.writeData((MeasuringValue)resultMeasurement);
                reportRecorder.flush();
                edp2ConfigFactory.finalizeRecorderConfigurationFactory();
                continue;
            }
            variationFactorTuple.setFactor(nestedInterval.valueAtPosition(0));
        }
        if (this.tuples2nestedIntervals.size() <= 0) return;
        VaryJob varyJob = new VaryJob(this.variationFactorTuples);
        varyJob.setBlackboard((Blackboard)((MDSDBlackboard)this.getBlackboard()));
        varyJob.execute(monitor);
        this.runAnalysisJob = this.toolAdapter.createRunAnalysisJob(this.experiment, (ToolConfiguration)this.simulationConfiguration, this.variationFactorTuples, this.repetition);
        this.runAnalysisJob.setBlackboard((Blackboard)((MDSDBlackboard)this.getBlackboard()));
        this.runAnalysisJob.execute(monitor);
        this.execute(monitor);
    }
}

