/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractSimulationConfiguration;
import org.palladiosimulator.experimentautomation.application.VariationFactorTuple;
import org.palladiosimulator.experimentautomation.application.jobs.RepeatExperimentJob;
import org.palladiosimulator.experimentautomation.application.jobs.VaryJob;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.IValueProviderStrategy;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.ValueProviderFactory;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.NestedIntervalsDoubleValueProvider;
import org.palladiosimulator.experimentautomation.experiments.NestedIntervalsLongValueProvider;
import org.palladiosimulator.experimentautomation.experiments.ValueProvider;
import org.palladiosimulator.experimentautomation.experiments.Variation;
import org.palladiosimulator.experimentautomation.experiments.util.ExperimentsSwitch;

public class ComputeVariantsAndAddExperimentJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    public ComputeVariantsAndAddExperimentJob(Experiment experiment, AbstractSimulationConfiguration simulationConfiguration) {
        super(false);
        this.computeVariantsAndAddJob(experiment, simulationConfiguration, (List<Variation>)experiment.getVariations(), new ArrayList<VariationFactorTuple>());
    }

    private void computeVariantsAndAddJob(final Experiment experiment, final AbstractSimulationConfiguration simulationConfiguration, List<Variation> variations, final List<VariationFactorTuple> variationFactorTuples) {
        if (variations.isEmpty()) {
            ArrayList<VariationFactorTuple> variationsAndFactorsCopy = new ArrayList<VariationFactorTuple>();
            variationsAndFactorsCopy.addAll(variationFactorTuples);
            this.add((IJob)new VaryJob(variationsAndFactorsCopy));
            this.add((IJob)new RepeatExperimentJob(experiment, simulationConfiguration, variationsAndFactorsCopy));
        } else {
            final ArrayList<Variation> copy = new ArrayList<Variation>();
            copy.addAll(variations);
            final Variation variation = (Variation)copy.remove(0);
            new ExperimentsSwitch<Void>(){

                public Void caseNestedIntervalsLongValueProvider(NestedIntervalsLongValueProvider object) {
                    IValueProviderStrategy<Long> valueProvider = ValueProviderFactory.createLongValueProvider((ValueProvider)object);
                    long factorLevel = 0L;
                    int iteration = 0;
                    while (factorLevel <= (long)variation.getMaxValue() && (long)iteration < variation.getMaxVariations()) {
                        factorLevel = valueProvider.valueAtPosition(iteration);
                        if (factorLevel == -1L) break;
                        if (factorLevel >= (long)variation.getMinValue() && factorLevel <= (long)variation.getMaxValue()) {
                            variationFactorTuples.add(new VariationFactorTuple<Long>(variation, factorLevel));
                            ComputeVariantsAndAddExperimentJob.this.computeVariantsAndAddJob(experiment, simulationConfiguration, copy, variationFactorTuples);
                            variationFactorTuples.remove(variationFactorTuples.size() - 1);
                        }
                        ++iteration;
                    }
                    return null;
                }

                public Void caseNestedIntervalsDoubleValueProvider(NestedIntervalsDoubleValueProvider object) {
                    IValueProviderStrategy<Double> valueProvider = ValueProviderFactory.createDoubleValueProvider((ValueProvider)object);
                    Double factorLevel = 0.0;
                    int iteration = 0;
                    while (factorLevel <= variation.getMaxValue() && (long)iteration < variation.getMaxVariations()) {
                        factorLevel = valueProvider.valueAtPosition(iteration);
                        if (factorLevel == -1.0) break;
                        if (factorLevel >= variation.getMinValue() && factorLevel <= variation.getMaxValue()) {
                            variationFactorTuples.add(new VariationFactorTuple<Double>(variation, factorLevel));
                            ComputeVariantsAndAddExperimentJob.this.computeVariantsAndAddJob(experiment, simulationConfiguration, copy, variationFactorTuples);
                            variationFactorTuples.remove(variationFactorTuples.size() - 1);
                        }
                        ++iteration;
                    }
                    return null;
                }
            }.doSwitch((EObject)variation.getValueProvider());
        }
    }
}

