/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractSimulationConfiguration;
import org.palladiosimulator.experimentautomation.abstractsimulation.ExportOption;
import org.palladiosimulator.experimentautomation.abstractsimulation.FileDatasource;
import org.palladiosimulator.experimentautomation.application.VariationFactorTuple;
import org.palladiosimulator.experimentautomation.application.jobs.AddDynamicVariationJob;
import org.palladiosimulator.experimentautomation.application.jobs.BatchExporterJob;
import org.palladiosimulator.experimentautomation.application.tooladapter.AnalysisToolFactory;
import org.palladiosimulator.experimentautomation.application.tooladapter.IToolAdapter;
import org.palladiosimulator.experimentautomation.application.tooladapter.RunAnalysisJob;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.ToolConfiguration;

public class RunExperimentJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    public RunExperimentJob(Experiment experiment, AbstractSimulationConfiguration simulationConfiguration, List<VariationFactorTuple> variationFactorTuples, int repetition) {
        super(false);
        FileDatasource source;
        IToolAdapter analysisTool = AnalysisToolFactory.createToolAdapater((ToolConfiguration)simulationConfiguration);
        RunAnalysisJob runAnalysisJob = analysisTool.createRunAnalysisJob(experiment, (ToolConfiguration)simulationConfiguration, variationFactorTuples, repetition);
        this.add((IJob)runAnalysisJob);
        this.add((IJob)new AddDynamicVariationJob(runAnalysisJob, analysisTool, experiment, simulationConfiguration, variationFactorTuples, repetition));
        if (FileDatasource.class.isAssignableFrom(simulationConfiguration.getDatasource().getClass()) && (source = (FileDatasource)simulationConfiguration.getDatasource()).getExportOption().equals((Object)ExportOption.CSV)) {
            this.add((IJob)new BatchExporterJob(source));
        }
    }
}

