/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.extension.AbstractWorkflowExtensionJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.core.emf.qvto.QVTOTransformationJob;
import de.uka.ipd.sdq.workflow.mdsd.core.emf.qvto.QVTOTransformationJobConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class SchedulingPolicy2DelayModificationJob
extends AbstractWorkflowExtensionJob<Blackboard<?>> {
    private static final String TRANSFORMATION_SCRIPT = "platform:/plugin/org.palladiosimulator.experimentautomation.application/transformations/SchedulingPolicy2Delay.qvto";

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        block4: {
            ModelLocation[] modelLocations = this.getRequiredModels();
            if (modelLocations == null && this.logger.isEnabledFor((Priority)Level.ERROR)) {
                throw new RuntimeException("Failed to load models from blackboard");
            }
            URI scriptFileURI = URI.createURI((String)TRANSFORMATION_SCRIPT);
            QVTOTransformationJobConfiguration qvtoConfig = new QVTOTransformationJobConfiguration();
            qvtoConfig.setInoutModels(modelLocations);
            qvtoConfig.setScriptFileURI(scriptFileURI);
            qvtoConfig.setOptions(new HashMap());
            QVTOTransformationJob job = new QVTOTransformationJob(qvtoConfig);
            job.setBlackboard((MDSDBlackboard)this.getBlackboard());
            try {
                job.execute((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JobFailedException e) {
                if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                    this.logger.error((Object)("Failed to perform SchedulingPolicy2Delay Transformation: " + e.getMessage()));
                }
                if (!this.logger.isEnabledFor((Priority)Level.INFO)) break block4;
                this.logger.info((Object)"Trying to continue SchedulingPolicy2Delay processing even though an internal failure occured");
            }
        }
    }

    private ModelLocation[] getRequiredModels() {
        ModelLocation allocationModelLocation = null;
        ModelLocation systemModelLocation = null;
        ModelLocation repositoryModelLocation = null;
        ModelLocation palladioResourcetypesModelLocation = null;
        String pcmModelPartitionId = "org.palladiosimulator.pcmmodels.partition";
        ResourceSetPartition partition = (ResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition");
        partition.resolveAllProxies();
        for (Resource r : partition.getResourceSet().getResources()) {
            URI modelURI = r.getURI();
            String fileExtension = modelURI.fileExtension();
            if (fileExtension.equals("allocation")) {
                allocationModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
            }
            if (fileExtension.equals("system")) {
                systemModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
            }
            if (fileExtension.equals("repository") && repositoryModelLocation == null && !modelURI.toString().startsWith("pathmap://") && !modelURI.toString().contains("PrimitiveTypes.repository")) {
                repositoryModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
            }
            if (!fileExtension.equals("resourcetype")) continue;
            palladioResourcetypesModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
        }
        ArrayList<ModelLocation> modelLocations = new ArrayList<ModelLocation>();
        modelLocations.add(allocationModelLocation);
        modelLocations.add(systemModelLocation);
        modelLocations.add(repositoryModelLocation);
        modelLocations.add(palladioResourcetypesModelLocation);
        return modelLocations.toArray(new ModelLocation[0]);
    }

    public String getName() {
        return "Add SchedulingPolicy2Delay transformation job";
    }
}

