/**
 */
package org.palladiosimulator.failuremodel.failuretype.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.palladiosimulator.failuremodel.failuretype.util.FailuretypeAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FailuretypeItemProviderAdapterFactory extends FailuretypeAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FailuretypeItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.FailureTypeRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FailureTypeRepositoryItemProvider failureTypeRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.FailureTypeRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFailureTypeRepositoryAdapter()
	{
		if (failureTypeRepositoryItemProvider == null)
		{
			failureTypeRepositoryItemProvider = new FailureTypeRepositoryItemProvider(this);
		}

		return failureTypeRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.SWCrashFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SWCrashFailureItemProvider swCrashFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.SWCrashFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSWCrashFailureAdapter()
	{
		if (swCrashFailureItemProvider == null)
		{
			swCrashFailureItemProvider = new SWCrashFailureItemProvider(this);
		}

		return swCrashFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.SWTimingFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SWTimingFailureItemProvider swTimingFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.SWTimingFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSWTimingFailureAdapter()
	{
		if (swTimingFailureItemProvider == null)
		{
			swTimingFailureItemProvider = new SWTimingFailureItemProvider(this);
		}

		return swTimingFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.SWContentFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SWContentFailureItemProvider swContentFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.SWContentFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSWContentFailureAdapter()
	{
		if (swContentFailureItemProvider == null)
		{
			swContentFailureItemProvider = new SWContentFailureItemProvider(this);
		}

		return swContentFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.SWTransientFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SWTransientFailureItemProvider swTransientFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.SWTransientFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSWTransientFailureAdapter()
	{
		if (swTransientFailureItemProvider == null)
		{
			swTransientFailureItemProvider = new SWTransientFailureItemProvider(this);
		}

		return swTransientFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.SWByzantineFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SWByzantineFailureItemProvider swByzantineFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.SWByzantineFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSWByzantineFailureAdapter()
	{
		if (swByzantineFailureItemProvider == null)
		{
			swByzantineFailureItemProvider = new SWByzantineFailureItemProvider(this);
		}

		return swByzantineFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.HWCrashFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HWCrashFailureItemProvider hwCrashFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.HWCrashFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHWCrashFailureAdapter()
	{
		if (hwCrashFailureItemProvider == null)
		{
			hwCrashFailureItemProvider = new HWCrashFailureItemProvider(this);
		}

		return hwCrashFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.HWTimingFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HWTimingFailureItemProvider hwTimingFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.HWTimingFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHWTimingFailureAdapter()
	{
		if (hwTimingFailureItemProvider == null)
		{
			hwTimingFailureItemProvider = new HWTimingFailureItemProvider(this);
		}

		return hwTimingFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.HWContentFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HWContentFailureItemProvider hwContentFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.HWContentFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHWContentFailureAdapter()
	{
		if (hwContentFailureItemProvider == null)
		{
			hwContentFailureItemProvider = new HWContentFailureItemProvider(this);
		}

		return hwContentFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.HWTransientFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HWTransientFailureItemProvider hwTransientFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.HWTransientFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHWTransientFailureAdapter()
	{
		if (hwTransientFailureItemProvider == null)
		{
			hwTransientFailureItemProvider = new HWTransientFailureItemProvider(this);
		}

		return hwTransientFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.HWByzantineFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HWByzantineFailureItemProvider hwByzantineFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.HWByzantineFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHWByzantineFailureAdapter()
	{
		if (hwByzantineFailureItemProvider == null)
		{
			hwByzantineFailureItemProvider = new HWByzantineFailureItemProvider(this);
		}

		return hwByzantineFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.LinkCrashFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkCrashFailureItemProvider linkCrashFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.LinkCrashFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkCrashFailureAdapter()
	{
		if (linkCrashFailureItemProvider == null)
		{
			linkCrashFailureItemProvider = new LinkCrashFailureItemProvider(this);
		}

		return linkCrashFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.LinkTimingFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkTimingFailureItemProvider linkTimingFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.LinkTimingFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkTimingFailureAdapter()
	{
		if (linkTimingFailureItemProvider == null)
		{
			linkTimingFailureItemProvider = new LinkTimingFailureItemProvider(this);
		}

		return linkTimingFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.LinkContentFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkContentFailureItemProvider linkContentFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.LinkContentFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkContentFailureAdapter()
	{
		if (linkContentFailureItemProvider == null)
		{
			linkContentFailureItemProvider = new LinkContentFailureItemProvider(this);
		}

		return linkContentFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.LinkTransientFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkTransientFailureItemProvider linkTransientFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.LinkTransientFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkTransientFailureAdapter()
	{
		if (linkTransientFailureItemProvider == null)
		{
			linkTransientFailureItemProvider = new LinkTransientFailureItemProvider(this);
		}

		return linkTransientFailureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.failuremodel.failuretype.LinkByzantineFailure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkByzantineFailureItemProvider linkByzantineFailureItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.failuremodel.failuretype.LinkByzantineFailure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkByzantineFailureAdapter()
	{
		if (linkByzantineFailureItemProvider == null)
		{
			linkByzantineFailureItemProvider = new LinkByzantineFailureItemProvider(this);
		}

		return linkByzantineFailureItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose()
	{
		if (failureTypeRepositoryItemProvider != null) failureTypeRepositoryItemProvider.dispose();
		if (swCrashFailureItemProvider != null) swCrashFailureItemProvider.dispose();
		if (swTimingFailureItemProvider != null) swTimingFailureItemProvider.dispose();
		if (swContentFailureItemProvider != null) swContentFailureItemProvider.dispose();
		if (swTransientFailureItemProvider != null) swTransientFailureItemProvider.dispose();
		if (swByzantineFailureItemProvider != null) swByzantineFailureItemProvider.dispose();
		if (hwCrashFailureItemProvider != null) hwCrashFailureItemProvider.dispose();
		if (hwTimingFailureItemProvider != null) hwTimingFailureItemProvider.dispose();
		if (hwContentFailureItemProvider != null) hwContentFailureItemProvider.dispose();
		if (hwTransientFailureItemProvider != null) hwTransientFailureItemProvider.dispose();
		if (hwByzantineFailureItemProvider != null) hwByzantineFailureItemProvider.dispose();
		if (linkCrashFailureItemProvider != null) linkCrashFailureItemProvider.dispose();
		if (linkTimingFailureItemProvider != null) linkTimingFailureItemProvider.dispose();
		if (linkContentFailureItemProvider != null) linkContentFailureItemProvider.dispose();
		if (linkTransientFailureItemProvider != null) linkTransientFailureItemProvider.dispose();
		if (linkByzantineFailureItemProvider != null) linkByzantineFailureItemProvider.dispose();
	}

}
