/**
 */
package org.palladiosimulator.failuremodel.failuretype;

import org.palladiosimulator.pcm.core.PCMRandomVariable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Transient</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * One-time termination, or for the specified duration.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.failuremodel.failuretype.Transient#getDuration <em>Duration</em>}</li>
 *   <li>{@link org.palladiosimulator.failuremodel.failuretype.Transient#getDecoratedFailure <em>Decorated Failure</em>}</li>
 * </ul>
 *
 * @see org.palladiosimulator.failuremodel.failuretype.FailuretypePackage#getTransient()
 * @model abstract="true"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore constraints='noTransientFailureAllowedForInternalFailureDescription'"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore/OCL noTransientFailureAllowedForInternalFailureDescription='not (self.decoratedFailure.oclIsKindOf(Transient))'"
 * @generated
 */
public interface Transient<Failuretype extends Failure> extends Mode
{
	/**
	 * Returns the value of the '<em><b>Duration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Duration</em>' containment reference.
	 * @see #setDuration(PCMRandomVariable)
	 * @see org.palladiosimulator.failuremodel.failuretype.FailuretypePackage#getTransient_Duration()
	 * @model containment="true" required="true"
	 * @generated
	 */
	PCMRandomVariable getDuration();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.failuremodel.failuretype.Transient#getDuration <em>Duration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Duration</em>' containment reference.
	 * @see #getDuration()
	 * @generated
	 */
	void setDuration(PCMRandomVariable value);

	/**
	 * Returns the value of the '<em><b>Decorated Failure</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Decorated Failure</em>' reference.
	 * @see #setDecoratedFailure(Failure)
	 * @see org.palladiosimulator.failuremodel.failuretype.FailuretypePackage#getTransient_DecoratedFailure()
	 * @model required="true"
	 * @generated
	 */
	Failuretype getDecoratedFailure();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.failuremodel.failuretype.Transient#getDecoratedFailure <em>Decorated Failure</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Decorated Failure</em>' reference.
	 * @see #getDecoratedFailure()
	 * @generated
	 */
	void setDecoratedFailure(Failuretype value);

} // Transient
