/**
 */
package org.palladiosimulator.failuremodel.failuretype.impl;

import de.uka.ipd.sdq.identifier.IdentifierPackage;

import de.uka.ipd.sdq.probfunction.ProbfunctionPackage;

import de.uka.ipd.sdq.stoex.StoexPackage;

import de.uka.ipd.sdq.units.UnitsPackage;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.palladiosimulator.failuremodel.failurescenario.FailurescenarioPackage;

import org.palladiosimulator.failuremodel.failurescenario.impl.FailurescenarioPackageImpl;

import org.palladiosimulator.failuremodel.failuretype.Byzantine;
import org.palladiosimulator.failuremodel.failuretype.Content;
import org.palladiosimulator.failuremodel.failuretype.Crash;
import org.palladiosimulator.failuremodel.failuretype.Domain;
import org.palladiosimulator.failuremodel.failuretype.Failure;
import org.palladiosimulator.failuremodel.failuretype.FailureTypeRepository;
import org.palladiosimulator.failuremodel.failuretype.FailuretypeFactory;
import org.palladiosimulator.failuremodel.failuretype.FailuretypePackage;
import org.palladiosimulator.failuremodel.failuretype.HWByzantineFailure;
import org.palladiosimulator.failuremodel.failuretype.HWContentFailure;
import org.palladiosimulator.failuremodel.failuretype.HWCrashFailure;
import org.palladiosimulator.failuremodel.failuretype.HWFailure;
import org.palladiosimulator.failuremodel.failuretype.HWTimingFailure;
import org.palladiosimulator.failuremodel.failuretype.HWTransientFailure;
import org.palladiosimulator.failuremodel.failuretype.LinkByzantineFailure;
import org.palladiosimulator.failuremodel.failuretype.LinkContentFailure;
import org.palladiosimulator.failuremodel.failuretype.LinkCrashFailure;
import org.palladiosimulator.failuremodel.failuretype.LinkFailure;
import org.palladiosimulator.failuremodel.failuretype.LinkTimingFailure;
import org.palladiosimulator.failuremodel.failuretype.LinkTransientFailure;
import org.palladiosimulator.failuremodel.failuretype.Mode;
import org.palladiosimulator.failuremodel.failuretype.SWByzantineFailure;
import org.palladiosimulator.failuremodel.failuretype.SWContentFailure;
import org.palladiosimulator.failuremodel.failuretype.SWCrashFailure;
import org.palladiosimulator.failuremodel.failuretype.SWFailure;
import org.palladiosimulator.failuremodel.failuretype.SWTimingFailure;
import org.palladiosimulator.failuremodel.failuretype.SWTransientFailure;
import org.palladiosimulator.failuremodel.failuretype.Timing;
import org.palladiosimulator.failuremodel.failuretype.Transient;

import org.palladiosimulator.failuremodel.failuretype.util.FailuretypeValidator;

import org.palladiosimulator.pcm.PcmPackage;

import org.palladiosimulator.pcm.core.CorePackage;

import org.palladiosimulator.pcm.core.entity.EntityPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class FailuretypePackageImpl extends EPackageImpl implements FailuretypePackage
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass failureTypeRepositoryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass failureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass swFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass linkFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass domainEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass timingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass crashEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass modeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass transientEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass byzantineEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass swCrashFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass swTimingFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass swContentFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass swTransientFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass swByzantineFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwCrashFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwTimingFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwContentFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwTransientFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwByzantineFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass linkCrashFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass linkTimingFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass linkContentFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass linkTransientFailureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass linkByzantineFailureEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.palladiosimulator.failuremodel.failuretype.FailuretypePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private FailuretypePackageImpl()
	{
		super(eNS_URI, FailuretypeFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link FailuretypePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static FailuretypePackage init()
	{
		if (isInited) return (FailuretypePackage)EPackage.Registry.INSTANCE.getEPackage(FailuretypePackage.eNS_URI);

		// Obtain or create and register package
		Object registeredFailuretypePackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		FailuretypePackageImpl theFailuretypePackage = registeredFailuretypePackage instanceof FailuretypePackageImpl ? (FailuretypePackageImpl)registeredFailuretypePackage : new FailuretypePackageImpl();

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();
		IdentifierPackage.eINSTANCE.eClass();
		PcmPackage.eINSTANCE.eClass();
		ProbfunctionPackage.eINSTANCE.eClass();
		StoexPackage.eINSTANCE.eClass();
		UnitsPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		Object registeredPackage = EPackage.Registry.INSTANCE.getEPackage(FailurescenarioPackage.eNS_URI);
		FailurescenarioPackageImpl theFailurescenarioPackage = (FailurescenarioPackageImpl)(registeredPackage instanceof FailurescenarioPackageImpl ? registeredPackage : FailurescenarioPackage.eINSTANCE);

		// Create package meta-data objects
		theFailuretypePackage.createPackageContents();
		theFailurescenarioPackage.createPackageContents();

		// Initialize created meta-data
		theFailuretypePackage.initializePackageContents();
		theFailurescenarioPackage.initializePackageContents();

		// Register package validator
		EValidator.Registry.INSTANCE.put
			(theFailuretypePackage,
			 new EValidator.Descriptor()
			 {
				 public EValidator getEValidator()
				 {
					 return FailuretypeValidator.INSTANCE;
				 }
			 });

		// Mark meta-data to indicate it can't be changed
		theFailuretypePackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(FailuretypePackage.eNS_URI, theFailuretypePackage);
		return theFailuretypePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFailureTypeRepository()
	{
		return failureTypeRepositoryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFailureTypeRepository_Failuretypes()
	{
		return (EReference)failureTypeRepositoryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFailure()
	{
		return failureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSWFailure()
	{
		return swFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHWFailure()
	{
		return hwFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLinkFailure()
	{
		return linkFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDomain()
	{
		return domainEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContent()
	{
		return contentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContent_DegreeOfCorruption()
	{
		return (EReference)contentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTiming()
	{
		return timingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTiming_Delay()
	{
		return (EReference)timingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTiming_ScalingFactor()
	{
		return (EReference)timingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCrash()
	{
		return crashEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMode()
	{
		return modeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTransient()
	{
		return transientEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTransient_Duration()
	{
		return (EReference)transientEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTransient_DecoratedFailure()
	{
		return (EReference)transientEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getByzantine()
	{
		return byzantineEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getByzantine_ProbabilityOfOccurrence()
	{
		return (EReference)byzantineEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getByzantine_DecoratedFailure()
	{
		return (EReference)byzantineEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSWCrashFailure()
	{
		return swCrashFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSWTimingFailure()
	{
		return swTimingFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSWContentFailure()
	{
		return swContentFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSWTransientFailure()
	{
		return swTransientFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSWByzantineFailure()
	{
		return swByzantineFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHWCrashFailure()
	{
		return hwCrashFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHWTimingFailure()
	{
		return hwTimingFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHWContentFailure()
	{
		return hwContentFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHWTransientFailure()
	{
		return hwTransientFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHWByzantineFailure()
	{
		return hwByzantineFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLinkCrashFailure()
	{
		return linkCrashFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLinkTimingFailure()
	{
		return linkTimingFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLinkContentFailure()
	{
		return linkContentFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLinkTransientFailure()
	{
		return linkTransientFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLinkByzantineFailure()
	{
		return linkByzantineFailureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FailuretypeFactory getFailuretypeFactory()
	{
		return (FailuretypeFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents()
	{
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		failureTypeRepositoryEClass = createEClass(FAILURE_TYPE_REPOSITORY);
		createEReference(failureTypeRepositoryEClass, FAILURE_TYPE_REPOSITORY__FAILURETYPES);

		failureEClass = createEClass(FAILURE);

		swFailureEClass = createEClass(SW_FAILURE);

		hwFailureEClass = createEClass(HW_FAILURE);

		linkFailureEClass = createEClass(LINK_FAILURE);

		domainEClass = createEClass(DOMAIN);

		contentEClass = createEClass(CONTENT);
		createEReference(contentEClass, CONTENT__DEGREE_OF_CORRUPTION);

		timingEClass = createEClass(TIMING);
		createEReference(timingEClass, TIMING__DELAY);
		createEReference(timingEClass, TIMING__SCALING_FACTOR);

		crashEClass = createEClass(CRASH);

		modeEClass = createEClass(MODE);

		transientEClass = createEClass(TRANSIENT);
		createEReference(transientEClass, TRANSIENT__DURATION);
		createEReference(transientEClass, TRANSIENT__DECORATED_FAILURE);

		byzantineEClass = createEClass(BYZANTINE);
		createEReference(byzantineEClass, BYZANTINE__PROBABILITY_OF_OCCURRENCE);
		createEReference(byzantineEClass, BYZANTINE__DECORATED_FAILURE);

		swCrashFailureEClass = createEClass(SW_CRASH_FAILURE);

		swTimingFailureEClass = createEClass(SW_TIMING_FAILURE);

		swContentFailureEClass = createEClass(SW_CONTENT_FAILURE);

		swTransientFailureEClass = createEClass(SW_TRANSIENT_FAILURE);

		swByzantineFailureEClass = createEClass(SW_BYZANTINE_FAILURE);

		hwCrashFailureEClass = createEClass(HW_CRASH_FAILURE);

		hwTimingFailureEClass = createEClass(HW_TIMING_FAILURE);

		hwContentFailureEClass = createEClass(HW_CONTENT_FAILURE);

		hwTransientFailureEClass = createEClass(HW_TRANSIENT_FAILURE);

		hwByzantineFailureEClass = createEClass(HW_BYZANTINE_FAILURE);

		linkCrashFailureEClass = createEClass(LINK_CRASH_FAILURE);

		linkTimingFailureEClass = createEClass(LINK_TIMING_FAILURE);

		linkContentFailureEClass = createEClass(LINK_CONTENT_FAILURE);

		linkTransientFailureEClass = createEClass(LINK_TRANSIENT_FAILURE);

		linkByzantineFailureEClass = createEClass(LINK_BYZANTINE_FAILURE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents()
	{
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EntityPackage theEntityPackage = (EntityPackage)EPackage.Registry.INSTANCE.getEPackage(EntityPackage.eNS_URI);
		CorePackage theCorePackage = (CorePackage)EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI);

		// Create type parameters
		ETypeParameter transientEClass_Failuretype = addETypeParameter(transientEClass, "Failuretype");
		ETypeParameter byzantineEClass_Failuretype = addETypeParameter(byzantineEClass, "Failuretype");

		// Set bounds for type parameters
		EGenericType g1 = createEGenericType(this.getFailure());
		transientEClass_Failuretype.getEBounds().add(g1);
		g1 = createEGenericType(this.getFailure());
		byzantineEClass_Failuretype.getEBounds().add(g1);

		// Add supertypes to classes
		failureTypeRepositoryEClass.getESuperTypes().add(theEntityPackage.getEntity());
		failureEClass.getESuperTypes().add(theEntityPackage.getEntity());
		swFailureEClass.getESuperTypes().add(this.getFailure());
		hwFailureEClass.getESuperTypes().add(this.getFailure());
		linkFailureEClass.getESuperTypes().add(this.getFailure());
		contentEClass.getESuperTypes().add(this.getDomain());
		timingEClass.getESuperTypes().add(this.getDomain());
		crashEClass.getESuperTypes().add(this.getDomain());
		transientEClass.getESuperTypes().add(this.getMode());
		byzantineEClass.getESuperTypes().add(this.getMode());
		swCrashFailureEClass.getESuperTypes().add(this.getSWFailure());
		swCrashFailureEClass.getESuperTypes().add(this.getCrash());
		swTimingFailureEClass.getESuperTypes().add(this.getSWFailure());
		swTimingFailureEClass.getESuperTypes().add(this.getTiming());
		swContentFailureEClass.getESuperTypes().add(this.getSWFailure());
		swContentFailureEClass.getESuperTypes().add(this.getContent());
		g1 = createEGenericType(this.getSWFailure());
		swTransientFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getTransient());
		EGenericType g2 = createEGenericType(this.getSWFailure());
		g1.getETypeArguments().add(g2);
		swTransientFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getSWFailure());
		swByzantineFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getByzantine());
		g2 = createEGenericType(this.getSWFailure());
		g1.getETypeArguments().add(g2);
		swByzantineFailureEClass.getEGenericSuperTypes().add(g1);
		hwCrashFailureEClass.getESuperTypes().add(this.getHWFailure());
		hwCrashFailureEClass.getESuperTypes().add(this.getCrash());
		hwTimingFailureEClass.getESuperTypes().add(this.getHWFailure());
		hwTimingFailureEClass.getESuperTypes().add(this.getTiming());
		hwContentFailureEClass.getESuperTypes().add(this.getHWFailure());
		hwContentFailureEClass.getESuperTypes().add(this.getContent());
		g1 = createEGenericType(this.getHWFailure());
		hwTransientFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getTransient());
		g2 = createEGenericType(this.getHWFailure());
		g1.getETypeArguments().add(g2);
		hwTransientFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getHWFailure());
		hwByzantineFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getByzantine());
		g2 = createEGenericType(this.getHWFailure());
		g1.getETypeArguments().add(g2);
		hwByzantineFailureEClass.getEGenericSuperTypes().add(g1);
		linkCrashFailureEClass.getESuperTypes().add(this.getLinkFailure());
		linkCrashFailureEClass.getESuperTypes().add(this.getCrash());
		linkTimingFailureEClass.getESuperTypes().add(this.getLinkFailure());
		linkTimingFailureEClass.getESuperTypes().add(this.getTiming());
		linkContentFailureEClass.getESuperTypes().add(this.getLinkFailure());
		linkContentFailureEClass.getESuperTypes().add(this.getContent());
		g1 = createEGenericType(this.getLinkFailure());
		linkTransientFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getTransient());
		g2 = createEGenericType(this.getLinkFailure());
		g1.getETypeArguments().add(g2);
		linkTransientFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getLinkFailure());
		linkByzantineFailureEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(this.getByzantine());
		g2 = createEGenericType(this.getLinkFailure());
		g1.getETypeArguments().add(g2);
		linkByzantineFailureEClass.getEGenericSuperTypes().add(g1);

		// Initialize classes and features; add operations and parameters
		initEClass(failureTypeRepositoryEClass, FailureTypeRepository.class, "FailureTypeRepository", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getFailureTypeRepository_Failuretypes(), this.getFailure(), null, "failuretypes", null, 0, -1, FailureTypeRepository.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(failureEClass, Failure.class, "Failure", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(failureEClass, ecorePackage.getEObject(), "getSupportedElementType", 1, -1, IS_UNIQUE, IS_ORDERED);

		initEClass(swFailureEClass, SWFailure.class, "SWFailure", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(swFailureEClass, ecorePackage.getEObject(), "getSupportedElementType", 1, -1, IS_UNIQUE, IS_ORDERED);

		initEClass(hwFailureEClass, HWFailure.class, "HWFailure", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(hwFailureEClass, ecorePackage.getEObject(), "getSupportedElementType", 1, -1, IS_UNIQUE, IS_ORDERED);

		initEClass(linkFailureEClass, LinkFailure.class, "LinkFailure", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(linkFailureEClass, ecorePackage.getEObject(), "getSupportedElementType", 1, -1, IS_UNIQUE, IS_ORDERED);

		initEClass(domainEClass, Domain.class, "Domain", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(contentEClass, Content.class, "Content", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getContent_DegreeOfCorruption(), theCorePackage.getPCMRandomVariable(), null, "degreeOfCorruption", null, 1, 1, Content.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(timingEClass, Timing.class, "Timing", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTiming_Delay(), theCorePackage.getPCMRandomVariable(), null, "delay", null, 1, 1, Timing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTiming_ScalingFactor(), theCorePackage.getPCMRandomVariable(), null, "scalingFactor", null, 1, 1, Timing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(crashEClass, Crash.class, "Crash", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(modeEClass, Mode.class, "Mode", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(transientEClass, Transient.class, "Transient", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTransient_Duration(), theCorePackage.getPCMRandomVariable(), null, "duration", null, 1, 1, Transient.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		g1 = createEGenericType(transientEClass_Failuretype);
		initEReference(getTransient_DecoratedFailure(), g1, null, "decoratedFailure", null, 1, 1, Transient.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(byzantineEClass, Byzantine.class, "Byzantine", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getByzantine_ProbabilityOfOccurrence(), theCorePackage.getPCMRandomVariable(), null, "probabilityOfOccurrence", null, 1, 1, Byzantine.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		g1 = createEGenericType(byzantineEClass_Failuretype);
		initEReference(getByzantine_DecoratedFailure(), g1, null, "decoratedFailure", null, 1, 1, Byzantine.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(swCrashFailureEClass, SWCrashFailure.class, "SWCrashFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(swTimingFailureEClass, SWTimingFailure.class, "SWTimingFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(swContentFailureEClass, SWContentFailure.class, "SWContentFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(swTransientFailureEClass, SWTransientFailure.class, "SWTransientFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(swByzantineFailureEClass, SWByzantineFailure.class, "SWByzantineFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(hwCrashFailureEClass, HWCrashFailure.class, "HWCrashFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(hwTimingFailureEClass, HWTimingFailure.class, "HWTimingFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(hwContentFailureEClass, HWContentFailure.class, "HWContentFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(hwTransientFailureEClass, HWTransientFailure.class, "HWTransientFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(hwByzantineFailureEClass, HWByzantineFailure.class, "HWByzantineFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(linkCrashFailureEClass, LinkCrashFailure.class, "LinkCrashFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(linkTimingFailureEClass, LinkTimingFailure.class, "LinkTimingFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(linkContentFailureEClass, LinkContentFailure.class, "LinkContentFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(linkTransientFailureEClass, LinkTransientFailure.class, "LinkTransientFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(linkByzantineFailureEClass, LinkByzantineFailure.class, "LinkByzantineFailure", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/Ecore
		createEcoreAnnotations();
		// http://www.eclipse.org/emf/2002/Ecore/OCL
		createOCLAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createEcoreAnnotations()
	{
		String source = "http://www.eclipse.org/emf/2002/Ecore";
		addAnnotation
		  (this,
		   source,
		   new String[]
		   {
			   "validationDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL"
		   });
		addAnnotation
		  (transientEClass,
		   source,
		   new String[]
		   {
			   "constraints", "noTransientFailureAllowedForInternalFailureDescription"
		   });
		addAnnotation
		  (byzantineEClass,
		   source,
		   new String[]
		   {
			   "constraints", "noByzantineOrTransientFailureAllowedForInternalFailureDescription"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/Ecore/OCL</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createOCLAnnotations()
	{
		String source = "http://www.eclipse.org/emf/2002/Ecore/OCL";
		addAnnotation
		  (transientEClass,
		   source,
		   new String[]
		   {
			   "noTransientFailureAllowedForInternalFailureDescription", "not (self.decoratedFailure.oclIsKindOf(Transient))"
		   });
		addAnnotation
		  (byzantineEClass,
		   source,
		   new String[]
		   {
			   "noByzantineOrTransientFailureAllowedForInternalFailureDescription", "not ( self.decoratedFailure.oclIsKindOf(Byzantine) or self.decoratedFailure.oclIsKindOf(Transient) )"
		   });
	}

} //FailuretypePackageImpl
