/**
 */
package org.palladiosimulator.failuremodel.failuretype.util;

import de.uka.ipd.sdq.identifier.util.IdentifierValidator;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.palladiosimulator.failuremodel.failuretype.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.failuremodel.failuretype.FailuretypePackage
 * @generated
 */
public class FailuretypeValidator extends EObjectValidator
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final FailuretypeValidator INSTANCE = new FailuretypeValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.failuremodel.failuretype";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FailuretypeValidator()
	{
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage()
	{
	  return FailuretypePackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		switch (classifierID)
		{
			case FailuretypePackage.FAILURE_TYPE_REPOSITORY:
				return validateFailureTypeRepository((FailureTypeRepository)value, diagnostics, context);
			case FailuretypePackage.FAILURE:
				return validateFailure((Failure)value, diagnostics, context);
			case FailuretypePackage.SW_FAILURE:
				return validateSWFailure((SWFailure)value, diagnostics, context);
			case FailuretypePackage.HW_FAILURE:
				return validateHWFailure((HWFailure)value, diagnostics, context);
			case FailuretypePackage.LINK_FAILURE:
				return validateLinkFailure((LinkFailure)value, diagnostics, context);
			case FailuretypePackage.DOMAIN:
				return validateDomain((Domain)value, diagnostics, context);
			case FailuretypePackage.CONTENT:
				return validateContent((Content)value, diagnostics, context);
			case FailuretypePackage.TIMING:
				return validateTiming((Timing)value, diagnostics, context);
			case FailuretypePackage.CRASH:
				return validateCrash((Crash)value, diagnostics, context);
			case FailuretypePackage.MODE:
				return validateMode((Mode)value, diagnostics, context);
			case FailuretypePackage.TRANSIENT:
				return validateTransient((Transient<?>)value, diagnostics, context);
			case FailuretypePackage.BYZANTINE:
				return validateByzantine((Byzantine<?>)value, diagnostics, context);
			case FailuretypePackage.SW_CRASH_FAILURE:
				return validateSWCrashFailure((SWCrashFailure)value, diagnostics, context);
			case FailuretypePackage.SW_TIMING_FAILURE:
				return validateSWTimingFailure((SWTimingFailure)value, diagnostics, context);
			case FailuretypePackage.SW_CONTENT_FAILURE:
				return validateSWContentFailure((SWContentFailure)value, diagnostics, context);
			case FailuretypePackage.SW_TRANSIENT_FAILURE:
				return validateSWTransientFailure((SWTransientFailure)value, diagnostics, context);
			case FailuretypePackage.SW_BYZANTINE_FAILURE:
				return validateSWByzantineFailure((SWByzantineFailure)value, diagnostics, context);
			case FailuretypePackage.HW_CRASH_FAILURE:
				return validateHWCrashFailure((HWCrashFailure)value, diagnostics, context);
			case FailuretypePackage.HW_TIMING_FAILURE:
				return validateHWTimingFailure((HWTimingFailure)value, diagnostics, context);
			case FailuretypePackage.HW_CONTENT_FAILURE:
				return validateHWContentFailure((HWContentFailure)value, diagnostics, context);
			case FailuretypePackage.HW_TRANSIENT_FAILURE:
				return validateHWTransientFailure((HWTransientFailure)value, diagnostics, context);
			case FailuretypePackage.HW_BYZANTINE_FAILURE:
				return validateHWByzantineFailure((HWByzantineFailure)value, diagnostics, context);
			case FailuretypePackage.LINK_CRASH_FAILURE:
				return validateLinkCrashFailure((LinkCrashFailure)value, diagnostics, context);
			case FailuretypePackage.LINK_TIMING_FAILURE:
				return validateLinkTimingFailure((LinkTimingFailure)value, diagnostics, context);
			case FailuretypePackage.LINK_CONTENT_FAILURE:
				return validateLinkContentFailure((LinkContentFailure)value, diagnostics, context);
			case FailuretypePackage.LINK_TRANSIENT_FAILURE:
				return validateLinkTransientFailure((LinkTransientFailure)value, diagnostics, context);
			case FailuretypePackage.LINK_BYZANTINE_FAILURE:
				return validateLinkByzantineFailure((LinkByzantineFailure)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFailureTypeRepository(FailureTypeRepository failureTypeRepository, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(failureTypeRepository, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(failureTypeRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(failureTypeRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(failureTypeRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(failureTypeRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(failureTypeRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(failureTypeRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(failureTypeRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(failureTypeRepository, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(failureTypeRepository, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFailure(Failure failure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(failure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(failure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(failure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(failure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(failure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(failure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(failure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(failure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(failure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(failure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSWFailure(SWFailure swFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(swFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(swFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(swFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(swFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(swFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(swFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(swFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(swFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(swFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(swFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHWFailure(HWFailure hwFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(hwFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(hwFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(hwFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(hwFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(hwFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(hwFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(hwFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(hwFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(hwFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(hwFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLinkFailure(LinkFailure linkFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(linkFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(linkFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(linkFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(linkFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(linkFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(linkFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(linkFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(linkFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(linkFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(linkFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDomain(Domain domain, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)domain, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateContent(Content content, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)content, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTiming(Timing timing, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)timing, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCrash(Crash crash, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)crash, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMode(Mode mode, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)mode, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTransient(Transient<?> transient_, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)transient_, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)transient_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)transient_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)transient_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)transient_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)transient_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)transient_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)transient_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)transient_, diagnostics, context);
		if (result || diagnostics != null) result &= validateTransient_noTransientFailureAllowedForInternalFailureDescription(transient_, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the noTransientFailureAllowedForInternalFailureDescription constraint of '<em>Transient</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String TRANSIENT__NO_TRANSIENT_FAILURE_ALLOWED_FOR_INTERNAL_FAILURE_DESCRIPTION__EEXPRESSION = "not (self.decoratedFailure.oclIsKindOf(Transient))";

	/**
	 * Validates the noTransientFailureAllowedForInternalFailureDescription constraint of '<em>Transient</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTransient_noTransientFailureAllowedForInternalFailureDescription(Transient<?> transient_, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(FailuretypePackage.Literals.TRANSIENT,
				 (EObject)transient_,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "noTransientFailureAllowedForInternalFailureDescription",
				 TRANSIENT__NO_TRANSIENT_FAILURE_ALLOWED_FOR_INTERNAL_FAILURE_DESCRIPTION__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateByzantine(Byzantine<?> byzantine, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)byzantine, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)byzantine, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)byzantine, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)byzantine, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)byzantine, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)byzantine, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)byzantine, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)byzantine, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)byzantine, diagnostics, context);
		if (result || diagnostics != null) result &= validateByzantine_noByzantineOrTransientFailureAllowedForInternalFailureDescription(byzantine, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the noByzantineOrTransientFailureAllowedForInternalFailureDescription constraint of '<em>Byzantine</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String BYZANTINE__NO_BYZANTINE_OR_TRANSIENT_FAILURE_ALLOWED_FOR_INTERNAL_FAILURE_DESCRIPTION__EEXPRESSION = "not ( self.decoratedFailure.oclIsKindOf(Byzantine) or self.decoratedFailure.oclIsKindOf(Transient) )";

	/**
	 * Validates the noByzantineOrTransientFailureAllowedForInternalFailureDescription constraint of '<em>Byzantine</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateByzantine_noByzantineOrTransientFailureAllowedForInternalFailureDescription(Byzantine<?> byzantine, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(FailuretypePackage.Literals.BYZANTINE,
				 (EObject)byzantine,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "noByzantineOrTransientFailureAllowedForInternalFailureDescription",
				 BYZANTINE__NO_BYZANTINE_OR_TRANSIENT_FAILURE_ALLOWED_FOR_INTERNAL_FAILURE_DESCRIPTION__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSWCrashFailure(SWCrashFailure swCrashFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(swCrashFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(swCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(swCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(swCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(swCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(swCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(swCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(swCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(swCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(swCrashFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSWTimingFailure(SWTimingFailure swTimingFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(swTimingFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(swTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(swTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(swTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(swTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(swTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(swTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(swTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(swTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(swTimingFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSWContentFailure(SWContentFailure swContentFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(swContentFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(swContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(swContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(swContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(swContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(swContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(swContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(swContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(swContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(swContentFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSWTransientFailure(SWTransientFailure swTransientFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(swTransientFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(swTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validateTransient_noTransientFailureAllowedForInternalFailureDescription(swTransientFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSWByzantineFailure(SWByzantineFailure swByzantineFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(swByzantineFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(swByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validateByzantine_noByzantineOrTransientFailureAllowedForInternalFailureDescription(swByzantineFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHWCrashFailure(HWCrashFailure hwCrashFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(hwCrashFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(hwCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(hwCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(hwCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(hwCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(hwCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(hwCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(hwCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(hwCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(hwCrashFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHWTimingFailure(HWTimingFailure hwTimingFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(hwTimingFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(hwTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(hwTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(hwTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(hwTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(hwTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(hwTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(hwTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(hwTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(hwTimingFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHWContentFailure(HWContentFailure hwContentFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(hwContentFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(hwContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(hwContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(hwContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(hwContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(hwContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(hwContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(hwContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(hwContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(hwContentFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHWTransientFailure(HWTransientFailure hwTransientFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(hwTransientFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(hwTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validateTransient_noTransientFailureAllowedForInternalFailureDescription(hwTransientFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHWByzantineFailure(HWByzantineFailure hwByzantineFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(hwByzantineFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(hwByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validateByzantine_noByzantineOrTransientFailureAllowedForInternalFailureDescription(hwByzantineFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLinkCrashFailure(LinkCrashFailure linkCrashFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(linkCrashFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(linkCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(linkCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(linkCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(linkCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(linkCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(linkCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(linkCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(linkCrashFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(linkCrashFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLinkTimingFailure(LinkTimingFailure linkTimingFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(linkTimingFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(linkTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(linkTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(linkTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(linkTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(linkTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(linkTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(linkTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(linkTimingFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(linkTimingFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLinkContentFailure(LinkContentFailure linkContentFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(linkContentFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(linkContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(linkContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(linkContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(linkContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(linkContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(linkContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(linkContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(linkContentFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(linkContentFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLinkTransientFailure(LinkTransientFailure linkTransientFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(linkTransientFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(linkTransientFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validateTransient_noTransientFailureAllowedForInternalFailureDescription(linkTransientFailure, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLinkByzantineFailure(LinkByzantineFailure linkByzantineFailure, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(linkByzantineFailure, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(linkByzantineFailure, diagnostics, context);
		if (result || diagnostics != null) result &= validateByzantine_noByzantineOrTransientFailureAllowedForInternalFailureDescription(linkByzantineFailure, diagnostics, context);
		return result;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator()
	{
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //FailuretypeValidator
