/**
 */
package org.palladiosimulator.failuremodel.failurescenario.util;

import de.uka.ipd.sdq.identifier.util.IdentifierValidator;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.palladiosimulator.failuremodel.failurescenario.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.failuremodel.failurescenario.FailurescenarioPackage
 * @generated
 */
public class FailurescenarioValidator extends EObjectValidator
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final FailurescenarioValidator INSTANCE = new FailurescenarioValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.failuremodel.failurescenario";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FailurescenarioValidator()
	{
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage()
	{
	  return FailurescenarioPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		switch (classifierID)
		{
			case FailurescenarioPackage.FAILURE_SCENARIO_REPOSITORY:
				return validateFailureScenarioRepository((FailureScenarioRepository)value, diagnostics, context);
			case FailurescenarioPackage.FAILURE_SCENARIO:
				return validateFailureScenario((FailureScenario)value, diagnostics, context);
			case FailurescenarioPackage.OCCURRENCE:
				return validateOccurrence((Occurrence)value, diagnostics, context);
			case FailurescenarioPackage.REFERENCE:
				return validateReference((Reference)value, diagnostics, context);
			case FailurescenarioPackage.LINKING_RESOURCE_REFERENCE:
				return validateLinkingResourceReference((LinkingResourceReference)value, diagnostics, context);
			case FailurescenarioPackage.INTERNAL_ACTION_REFERENCE:
				return validateInternalActionReference((InternalActionReference)value, diagnostics, context);
			case FailurescenarioPackage.PROCESSING_RESOURCE_REFERENCE:
				return validateProcessingResourceReference((ProcessingResourceReference)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFailureScenarioRepository(FailureScenarioRepository failureScenarioRepository, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(failureScenarioRepository, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(failureScenarioRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(failureScenarioRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(failureScenarioRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(failureScenarioRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(failureScenarioRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(failureScenarioRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(failureScenarioRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(failureScenarioRepository, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(failureScenarioRepository, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFailureScenario(FailureScenario failureScenario, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(failureScenario, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(failureScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(failureScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(failureScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(failureScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(failureScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(failureScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(failureScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(failureScenario, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(failureScenario, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOccurrence(Occurrence occurrence, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)occurrence, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)occurrence, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)occurrence, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)occurrence, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)occurrence, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)occurrence, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)occurrence, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)occurrence, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)occurrence, diagnostics, context);
		if (result || diagnostics != null) result &= validateOccurrence_ensureCorrectOrigin(occurrence, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the ensureCorrectOrigin constraint of '<em>Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String OCCURRENCE__ENSURE_CORRECT_ORIGIN__EEXPRESSION = "( self.origin.oclIsTypeOf(LinkingResourceReference) and ( self.failure.oclIsKindOf(failuretype::LinkFailure) ) )\n" +
		"or\n" +
		"( self.origin.oclIsTypeOf(ProcessingResourceReference) and ( self.failure.oclIsKindOf(failuretype::HWFailure) ) )\n" +
		"or\n" +
		"( self.origin.oclIsTypeOf(InternalActionReference) and ( self.failure.oclIsKindOf(failuretype::SWFailure) ) )";

	/**
	 * Validates the ensureCorrectOrigin constraint of '<em>Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOccurrence_ensureCorrectOrigin(Occurrence occurrence, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(FailurescenarioPackage.Literals.OCCURRENCE,
				 (EObject)occurrence,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "ensureCorrectOrigin",
				 OCCURRENCE__ENSURE_CORRECT_ORIGIN__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateReference(Reference reference, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)reference, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLinkingResourceReference(LinkingResourceReference linkingResourceReference, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)linkingResourceReference, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateInternalActionReference(InternalActionReference internalActionReference, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)internalActionReference, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProcessingResourceReference(ProcessingResourceReference processingResourceReference, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)processingResourceReference, diagnostics, context);
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator()
	{
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //FailurescenarioValidator
