/**
 */
package org.palladiosimulator.failuremodel.failuretype;

import org.palladiosimulator.pcm.core.PCMRandomVariable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Byzantine</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Generates the stored failure type and triggers it every time with the probability of occurrence.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.failuremodel.failuretype.Byzantine#getProbabilityOfOccurrence <em>Probability Of Occurrence</em>}</li>
 *   <li>{@link org.palladiosimulator.failuremodel.failuretype.Byzantine#getDecoratedFailure <em>Decorated Failure</em>}</li>
 * </ul>
 *
 * @see org.palladiosimulator.failuremodel.failuretype.FailuretypePackage#getByzantine()
 * @model abstract="true"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore constraints='noByzantineOrTransientFailureAllowedForInternalFailureDescription'"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore/OCL noByzantineOrTransientFailureAllowedForInternalFailureDescription='not ( self.decoratedFailure.oclIsKindOf(Byzantine) or self.decoratedFailure.oclIsKindOf(Transient) )'"
 * @generated
 */
public interface Byzantine<Failuretype extends Failure> extends Mode
{
	/**
	 * Returns the value of the '<em><b>Probability Of Occurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Probability Of Occurrence</em>' containment reference.
	 * @see #setProbabilityOfOccurrence(PCMRandomVariable)
	 * @see org.palladiosimulator.failuremodel.failuretype.FailuretypePackage#getByzantine_ProbabilityOfOccurrence()
	 * @model containment="true" required="true"
	 * @generated
	 */
	PCMRandomVariable getProbabilityOfOccurrence();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.failuremodel.failuretype.Byzantine#getProbabilityOfOccurrence <em>Probability Of Occurrence</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Probability Of Occurrence</em>' containment reference.
	 * @see #getProbabilityOfOccurrence()
	 * @generated
	 */
	void setProbabilityOfOccurrence(PCMRandomVariable value);

	/**
	 * Returns the value of the '<em><b>Decorated Failure</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Decorated Failure</em>' reference.
	 * @see #setDecoratedFailure(Failure)
	 * @see org.palladiosimulator.failuremodel.failuretype.FailuretypePackage#getByzantine_DecoratedFailure()
	 * @model required="true"
	 * @generated
	 */
	Failuretype getDecoratedFailure();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.failuremodel.failuretype.Byzantine#getDecoratedFailure <em>Decorated Failure</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Decorated Failure</em>' reference.
	 * @see #getDecoratedFailure()
	 * @generated
	 */
	void setDecoratedFailure(Failuretype value);

} // Byzantine
