/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.failurescenario.interpreter.behavior.preinterpretation;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.ValueNotInFrameException;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.ArrayList;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.preinterpretation.PreInterpretationBehavior;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;

public class CorruptContentBehavior
extends PreInterpretationBehavior {
    private String degreeOfCorruptionSpec;

    public CorruptContentBehavior(String degreeOfCorruptionSpec) {
        super(InterpreterResult.OK);
        this.degreeOfCorruptionSpec = degreeOfCorruptionSpec;
    }

    public InterpreterResult execute(InterpreterDefaultContext context) {
        if (context != null) {
            this.setDegreeOfCorruptionCharacterisation(context);
        }
        return super.execute(context);
    }

    private void setDegreeOfCorruptionCharacterisation(InterpreterDefaultContext context) {
        double corruptionSummand = NumberConverter.toDouble((Object)StackContext.evaluateStatic((String)this.degreeOfCorruptionSpec));
        ArrayList entries = context.getStack().currentStackFrame().getContents();
        ArrayList entriesOfResult = context.getCurrentResultFrame().getContents();
        SimulatedStackframe resultFrame = context.getCurrentResultFrame();
        try {
            resultFrame.getValue("parameter0.DEGREE_OF_CORRUPTION.VALUE");
        }
        catch (ValueNotInFrameException e1) {
            e1.printStackTrace();
        }
        entries.addAll(entriesOfResult);
        entries.forEach(e -> {
            String key = (String)e.getKey();
            if (key.endsWith(".DEGREE_OF_CORRUPTION.VALUE")) {
                try {
                    double newDegreeOfCorruption = Math.max(0.0, Math.min(1.0, (Double)context.getStack().currentStackFrame().getValue(key) + corruptionSummand));
                    context.getStack().currentStackFrame().addValue(key, (Object)newDegreeOfCorruption);
                    resultFrame.addValue(key, (Object)newDegreeOfCorruption);
                }
                catch (ValueNotInFrameException valueNotInFrameException) {
                    // empty catch block
                }
            }
        });
    }
}

