/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.failurescenario.interpreter.provider;

import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.core.resources.DemandModifyingBehavior;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.failuremodel.failuretype.Byzantine;
import org.palladiosimulator.failuremodel.failuretype.Content;
import org.palladiosimulator.failuremodel.failuretype.Crash;
import org.palladiosimulator.failuremodel.failuretype.Failure;
import org.palladiosimulator.failuremodel.failuretype.SWTimingFailure;
import org.palladiosimulator.failuremodel.failuretype.Timing;
import org.palladiosimulator.failuremodel.failuretype.Transient;
import org.palladiosimulator.failuremodel.failuretype.util.FailuretypeSwitch;
import org.palladiosimulator.simulizar.failurescenario.interpreter.behavior.ProbabilisticDecider;
import org.palladiosimulator.simulizar.failurescenario.interpreter.behavior.preinterpretation.CorruptContentBehavior;
import org.palladiosimulator.simulizar.failurescenario.interpreter.behavior.preinterpretation.CrashBehavior;
import org.palladiosimulator.simulizar.failurescenario.interpreter.behavior.preinterpretation.DelayBehavior;
import org.palladiosimulator.simulizar.failurescenario.interpreter.dto.FailureBehaviorChange;
import org.palladiosimulator.simulizar.failurescenario.interpreter.strategies.impl.AddDemandModifyingBehaviorStrategy;
import org.palladiosimulator.simulizar.failurescenario.interpreter.strategies.impl.AddPreInterpretationBehaviorStrategy;

public class FailureBehaviorChangesProviderSwitch
extends FailuretypeSwitch<List<FailureBehaviorChange>> {
    private final IRandomGenerator randomNumberGenerator;

    public FailureBehaviorChangesProviderSwitch(IRandomGenerator randomNumberGenerator) {
        this.randomNumberGenerator = randomNumberGenerator;
    }

    public List<FailureBehaviorChange> caseCrash(Crash object) {
        FailureBehaviorChange dto = null;
        if (object instanceof Failure) {
            dto = new FailureBehaviorChange(new AddPreInterpretationBehaviorStrategy(new CrashBehavior((Failure)object)), 0.0);
        }
        return Arrays.asList(dto);
    }

    public List<FailureBehaviorChange> caseTiming(Timing object) {
        DemandModifyingBehavior dmb = new DemandModifyingBehavior(object.getScalingFactor().getSpecification(), object.getDelay().getSpecification());
        return Arrays.asList(new FailureBehaviorChange(new AddDemandModifyingBehaviorStrategy(dmb), 0.0));
    }

    public List<FailureBehaviorChange> caseSWTimingFailure(SWTimingFailure object) {
        DelayBehavior delayPib = new DelayBehavior(object.getDelay().getSpecification());
        return Arrays.asList(new FailureBehaviorChange(new AddPreInterpretationBehaviorStrategy(delayPib), 0.0));
    }

    public List<FailureBehaviorChange> caseContent(Content object) {
        FailureBehaviorChange dto = new FailureBehaviorChange(new AddPreInterpretationBehaviorStrategy(new CorruptContentBehavior(object.getDegreeOfCorruption().getSpecification())), 0.0);
        return Arrays.asList(dto);
    }

    public <Failuretype extends Failure> List<FailureBehaviorChange> caseTransient(Transient<Failuretype> object) {
        FailureBehaviorChange addingBehavior = (FailureBehaviorChange)this.doSwitch((EObject)object.getDecoratedFailure()).get(0);
        Double relativePointInTimeOfRemoving = NumberConverter.toDouble((Object)StackContext.evaluateStatic((String)object.getDuration().getSpecification()));
        FailureBehaviorChange removingBehavior = new FailureBehaviorChange(addingBehavior.getStrategy().getRevertedStrategy(), relativePointInTimeOfRemoving);
        return Arrays.asList(addingBehavior, removingBehavior);
    }

    public <Failuretype extends Failure> List<FailureBehaviorChange> caseByzantine(Byzantine<Failuretype> object) {
        String probabilitySpec = object.getProbabilityOfOccurrence().getSpecification();
        ProbabilisticDecider decider = new ProbabilisticDecider(this.randomNumberGenerator, probabilitySpec);
        FailureBehaviorChange behavior = (FailureBehaviorChange)this.doSwitch((EObject)object.getDecoratedFailure()).get(0);
        behavior.getStrategy().setDecider(decider);
        return Arrays.asList(behavior);
    }

    public List<FailureBehaviorChange> doSwitch(EObject object) {
        return (List)super.doSwitch(object);
    }
}

