/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.failurescenario.interpreter;

import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.core.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEventFactory;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.failuremodel.failurescenario.FailureScenario;
import org.palladiosimulator.failuremodel.failurescenario.FailureScenarioRepository;
import org.palladiosimulator.failuremodel.failurescenario.FailurescenarioPackage;
import org.palladiosimulator.failuremodel.failurescenario.Occurrence;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.failurescenario.interpreter.FailureBehaviorChangingSimulationEntity;
import org.palladiosimulator.simulizar.failurescenario.interpreter.behavior.preinterpretation.AddDegreeOfCorruptionCharacterisationBehavior;
import org.palladiosimulator.simulizar.failurescenario.interpreter.dto.FailureBehaviorChange;
import org.palladiosimulator.simulizar.failurescenario.interpreter.dto.StrategyAllocationContext;
import org.palladiosimulator.simulizar.failurescenario.interpreter.provider.FailureBehaviorChangesProviderSwitch;
import org.palladiosimulator.simulizar.failurescenario.interpreter.provider.ReferenceResolverSwitch;
import org.palladiosimulator.simulizar.failurescenario.interpreter.provider.ScheduledResourceProviderSwitch;
import org.palladiosimulator.simulizar.interpreter.preinterpretation.PreInterpretationBehavior;
import org.palladiosimulator.simulizar.modelobserver.AllocationLookupSyncer;
import org.palladiosimulator.simulizar.modelobserver.IModelObserver;
import org.palladiosimulator.simulizar.runtimestate.PreInterpretationBehaviorManager;

public class FailurescenarioObserver
implements IModelObserver {
    private static final Logger LOGGER = Logger.getLogger(AllocationLookupSyncer.class);
    private PCMResourceSetPartition globalPartition;
    private FailureScenarioRepository fsRepository;
    private ISimEventFactory simEventFactory;
    private final PreInterpretationBehaviorManager pibManager;
    private final ScheduledResourceProviderSwitch resourceProvider;
    private final IRandomGenerator randomNumberGenerator;

    @Inject
    public FailurescenarioObserver(ISimEventFactory simEventFactory, @PCMPartitionManager.Global PCMResourceSetPartition globalPartition, PreInterpretationBehaviorManager pibManager, ResourceRegistry resourceRegistry, IRandomGenerator randomNumberGenerator) {
        this.simEventFactory = simEventFactory;
        this.globalPartition = globalPartition;
        this.pibManager = pibManager;
        this.randomNumberGenerator = randomNumberGenerator;
        this.resourceProvider = new ScheduledResourceProviderSwitch(resourceRegistry);
        this.fsRepository = null;
    }

    public void initialize() {
        List failureScenarioResources = this.globalPartition.getElement(FailurescenarioPackage.eINSTANCE.getFailureScenarioRepository());
        if (!failureScenarioResources.isEmpty()) {
            LOGGER.info((Object)"Start loading failurescenarios");
            this.fsRepository = (FailureScenarioRepository)failureScenarioResources.get(0);
            this.fsRepository.getFailurescenarios().forEach(fs -> this.registerOccurences((FailureScenario)fs));
        }
        this.pibManager.getContainerForEntity(SeffPackage.eINSTANCE.getStartAction()).addBehavior((PreInterpretationBehavior)new AddDegreeOfCorruptionCharacterisationBehavior());
    }

    private void registerOccurences(FailureScenario fs) {
        if (fs.getExecutionEnabled() != null && !fs.getExecutionEnabled().booleanValue()) {
            return;
        }
        ReferenceResolverSwitch referenceResolver = new ReferenceResolverSwitch();
        FailureBehaviorChangesProviderSwitch fbChangesProvider = new FailureBehaviorChangesProviderSwitch(this.randomNumberGenerator);
        fs.getOccurrences().forEach(o -> {
            Object fbChangeDTOs = fbChangesProvider.doSwitch((EObject)o.getFailure());
            StrategyAllocationContext allocationContext = new StrategyAllocationContext(referenceResolver, this.resourceProvider, this.pibManager, (Occurrence)o);
            Iterator iterator = fbChangeDTOs.iterator();
            while (iterator.hasNext()) {
                FailureBehaviorChange dto = (FailureBehaviorChange)iterator.next();
                if (dto == null || !dto.getStrategy().allocateContext(allocationContext)) continue;
                double simulationPointInTime = NumberConverter.toDouble((Object)StackContext.evaluateStatic((String)o.getPointInTime().getSpecification()));
                new FailureBehaviorChangingSimulationEntity(this.simEventFactory, simulationPointInTime + dto.getRelativePointInTime(), dto.getStrategy());
            }
        });
    }
}

