/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.api.seff.Seff;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.CompleteComponentTypeCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.Component;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.EventGroupCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.InfrastructureInterfaceCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationInterfaceCreator;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.reliability.ResourceTimeoutFailureType;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompleteComponentType;
import org.palladiosimulator.pcm.repository.ComponentType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;

public class BasicComponentCreator
extends Component {
    private ComponentType type;
    private final List<CompleteComponentType> conformsCompleteTypes;
    private final List<PassiveResource> passiveResources;
    private final List<ServiceEffectSpecification> seffs;
    private final List<VariableUsage> componentParameterUsages;

    public BasicComponentCreator(RepositoryCreator repo) {
        this.repository = repo;
        this.conformsCompleteTypes = new ArrayList<CompleteComponentType>();
        this.passiveResources = new ArrayList<PassiveResource>();
        this.seffs = new ArrayList<ServiceEffectSpecification>();
        this.componentParameterUsages = new ArrayList<VariableUsage>();
    }

    @Override
    public BasicComponentCreator withName(String name) {
        return (BasicComponentCreator)super.withName(name);
    }

    public BasicComponentCreator ofType(ComponentType type) {
        IllegalArgumentException.throwIfNull(type, "type must not be null");
        this.type = type;
        return this;
    }

    @Override
    public BasicComponentCreator provides(OperationInterfaceCreator interfce) {
        return (BasicComponentCreator)super.provides(interfce);
    }

    @Override
    public BasicComponentCreator provides(OperationInterfaceCreator interfce, String name) {
        return (BasicComponentCreator)super.provides(interfce, name);
    }

    @Override
    public BasicComponentCreator provides(OperationInterface interfce) {
        return (BasicComponentCreator)super.provides(interfce);
    }

    @Override
    public BasicComponentCreator provides(OperationInterface interfce, String name) {
        return (BasicComponentCreator)super.provides(interfce, name);
    }

    @Override
    public BasicComponentCreator providesInfrastructure(InfrastructureInterfaceCreator interfce) {
        return (BasicComponentCreator)super.providesInfrastructure(interfce);
    }

    @Override
    public BasicComponentCreator providesInfrastructure(InfrastructureInterfaceCreator interfce, String name) {
        return (BasicComponentCreator)super.providesInfrastructure(interfce, name);
    }

    @Override
    public BasicComponentCreator providesInfrastructure(InfrastructureInterface interfce) {
        return (BasicComponentCreator)super.providesInfrastructure(interfce);
    }

    @Override
    public BasicComponentCreator providesInfrastructure(InfrastructureInterface interfce, String name) {
        return (BasicComponentCreator)super.providesInfrastructure(interfce, name);
    }

    @Override
    public BasicComponentCreator handles(EventGroupCreator eventGroup) {
        return (BasicComponentCreator)super.handles(eventGroup);
    }

    @Override
    public BasicComponentCreator handles(EventGroupCreator eventGroup, String name) {
        return (BasicComponentCreator)super.handles(eventGroup, name);
    }

    @Override
    public BasicComponentCreator handles(EventGroup eventGroup) {
        return (BasicComponentCreator)super.handles(eventGroup);
    }

    @Override
    public BasicComponentCreator handles(EventGroup eventGroup, String name) {
        return (BasicComponentCreator)super.handles(eventGroup, name);
    }

    @Override
    public BasicComponentCreator requires(OperationInterfaceCreator interfce) {
        return (BasicComponentCreator)super.requires(interfce);
    }

    @Override
    public BasicComponentCreator requires(OperationInterfaceCreator interfce, String name) {
        return (BasicComponentCreator)super.requires(interfce, name);
    }

    @Override
    public BasicComponentCreator requires(OperationInterface interfce) {
        return (BasicComponentCreator)super.requires(interfce);
    }

    @Override
    public BasicComponentCreator requires(OperationInterface interfce, String name) {
        return (BasicComponentCreator)super.requires(interfce, name);
    }

    @Override
    public BasicComponentCreator requiresInfrastructure(InfrastructureInterfaceCreator interfce) {
        return (BasicComponentCreator)super.requiresInfrastructure(interfce);
    }

    @Override
    public BasicComponentCreator requiresInfrastructure(InfrastructureInterfaceCreator interfce, String name) {
        return (BasicComponentCreator)super.requiresInfrastructure(interfce, name);
    }

    @Override
    public BasicComponentCreator requiresInfrastructure(InfrastructureInterface interfce) {
        return (BasicComponentCreator)super.requiresInfrastructure(interfce);
    }

    @Override
    public BasicComponentCreator requiresInfrastructure(InfrastructureInterface interfce, String name) {
        return (BasicComponentCreator)super.requiresInfrastructure(interfce, name);
    }

    @Override
    public BasicComponentCreator emits(EventGroupCreator eventGroup) {
        return (BasicComponentCreator)super.emits(eventGroup);
    }

    @Override
    public BasicComponentCreator emits(EventGroupCreator eventGroup, String name) {
        return (BasicComponentCreator)super.emits(eventGroup, name);
    }

    @Override
    public BasicComponentCreator emits(EventGroup eventGroup) {
        return (BasicComponentCreator)super.emits(eventGroup);
    }

    @Override
    public BasicComponentCreator emits(EventGroup eventGroup, String name) {
        return (BasicComponentCreator)super.emits(eventGroup, name);
    }

    @Override
    public BasicComponentCreator requiresResource(ResourceInterface resourceInterface) {
        return (BasicComponentCreator)super.requiresResource(resourceInterface);
    }

    @Override
    public BasicComponentCreator requiresResource(ResourceInterface resourceInterface, String name) {
        return (BasicComponentCreator)super.requiresResource(resourceInterface, name);
    }

    public BasicComponentCreator conforms(CompleteComponentTypeCreator completeComponentType) {
        IllegalArgumentException.throwIfNull(completeComponentType, "completeComponentType must not be null");
        CompleteComponentType cct = completeComponentType.build();
        this.repository.addComponent((RepositoryComponent)cct);
        return this.conforms(cct);
    }

    public BasicComponentCreator conforms(CompleteComponentType completeComponentType) {
        IllegalArgumentException.throwIfNull(completeComponentType, "completeComponentType must not be null");
        this.conformsCompleteTypes.add(completeComponentType);
        return this;
    }

    public BasicComponentCreator withPassiveResource(String capacityStochasticExpression, ResourceTimeoutFailureType failureType, String name) {
        IllegalArgumentException.throwIfNull(capacityStochasticExpression, "capacity_stochasticExpression must not be null");
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        PCMRandomVariable randVar = CoreFactory.eINSTANCE.createPCMRandomVariable();
        randVar.setSpecification(capacityStochasticExpression);
        PassiveResource pass = RepositoryFactory.eINSTANCE.createPassiveResource();
        pass.setCapacity_PassiveResource(randVar);
        pass.setResourceTimeoutFailureType__PassiveResource(failureType);
        pass.setEntityName(name);
        this.repository.addPassiveResource(pass);
        this.passiveResources.add(pass);
        return this;
    }

    public BasicComponentCreator withPassiveResource(String capacityStochasticExpression, ResourceTimeoutFailureType failureType) {
        return this.withPassiveResource(capacityStochasticExpression, failureType, null);
    }

    public BasicComponentCreator withServiceEffectSpecification(Seff seff) {
        IllegalArgumentException.throwIfNull(seff, "seff must not be null");
        return this.withServiceEffectSpecification(seff.build());
    }

    public BasicComponentCreator withServiceEffectSpecification(ServiceEffectSpecification seff) {
        IllegalArgumentException.throwIfNull(seff, "seff must not be null");
        this.seffs.add(seff);
        return this;
    }

    public BasicComponentCreator withVariableUsage(VariableUsageCreator variableUsage) {
        IllegalArgumentException.throwIfNull(variableUsage, "variableUsage must not be null");
        this.componentParameterUsages.add(variableUsage.build());
        return this;
    }

    public BasicComponent build() {
        BasicComponent basicComponent = RepositoryFactory.eINSTANCE.createBasicComponent();
        if (this.name != null) {
            basicComponent.setEntityName(this.name);
        }
        if (this.type != null) {
            basicComponent.setComponentType(this.type);
        }
        basicComponent.getProvidedRoles_InterfaceProvidingEntity().addAll((Collection)this.providedRoles);
        basicComponent.getRequiredRoles_InterfaceRequiringEntity().addAll((Collection)this.requiredRoles);
        basicComponent.getResourceRequiredRoles__ResourceInterfaceRequiringEntity().addAll((Collection)this.resourceRequiredRoles);
        basicComponent.getParentCompleteComponentTypes().addAll(this.conformsCompleteTypes);
        basicComponent.getComponentParameterUsage_ImplementationComponentType().addAll(this.componentParameterUsages);
        basicComponent.getPassiveResource_BasicComponent().addAll(this.passiveResources);
        basicComponent.getServiceEffectSpecifications__BasicComponent().addAll(this.seffs);
        return basicComponent;
    }

    protected void addVariableUsage(VariableUsage varUsage) {
        this.componentParameterUsages.add(varUsage);
    }
}

