/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.resource;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.resource.ResourceRequiredRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.RequiredResourceDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;

public class RequiredResourceDelegationConnectorCreator
extends AbstractConnectorCreator {
    private ResourceRequiredRole outerRequiredRole;
    private ResourceRequiredRole innerRequiredRole;
    private AssemblyContext requringAssemblyContext;

    public RequiredResourceDelegationConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public RequiredResourceDelegationConnectorCreator withOuterRequiredRole(ResourceRequiredRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.outerRequiredRole = role;
        return this;
    }

    public RequiredResourceDelegationConnectorCreator withOuterRequiredRole(String name) throws NoSuchElementException {
        ResourceRequiredRole role = this.system.getSystemResourceRequiredRoleByName(name);
        return this.withOuterRequiredRole(role);
    }

    public ResourceRequiredRoleSelector withRequiringContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new ResourceRequiredRoleSelector((context1, role) -> {
            this.requringAssemblyContext = context1;
            this.innerRequiredRole = role;
            return this;
        }, context);
    }

    public ResourceRequiredRoleSelector withRequiringContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withRequiringContext(context);
    }

    public RequiredResourceDelegationConnector build() {
        RequiredResourceDelegationConnector connector = CompositionFactory.eINSTANCE.createRequiredResourceDelegationConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setAssemblyContext__RequiredResourceDelegationConnector(this.requringAssemblyContext);
        connector.setOuterRequiredRole__RequiredResourceDelegationConnector(this.outerRequiredRole);
        connector.setInnerRequiredRole__RequiredResourceDelegationConnector(this.innerRequiredRole);
        return connector;
    }

    @Override
    public RequiredResourceDelegationConnectorCreator withName(String name) {
        return (RequiredResourceDelegationConnectorCreator)super.withName(name);
    }
}

