/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.ActionCreator;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;

public class DelayActionCreator
extends ActionCreator {
    private PCMRandomVariable time;

    public DelayActionCreator(String timeSpecification) {
        this.addToDelayAction(timeSpecification);
    }

    private DelayActionCreator addToDelayAction(String timeSpecification) {
        IllegalArgumentException.throwIfNull(timeSpecification, "The given Time Sppecification must not be null");
        this.time = CoreFactory.eINSTANCE.createPCMRandomVariable();
        this.time.setSpecification(timeSpecification);
        return this;
    }

    public Delay build() {
        Delay d = UsagemodelFactory.eINSTANCE.createDelay();
        if (this.time != null) {
            d.setTimeSpecification_Delay(this.time);
        }
        if (this.name != null) {
            d.setEntityName(this.name);
        }
        if (this.successor != null) {
            d.setSuccessor(this.successor);
        }
        return d;
    }

    @Override
    public DelayActionCreator withSuccessor(ActionCreator action) {
        return (DelayActionCreator)super.withSuccessor(action);
    }

    @Override
    public DelayActionCreator withName(String name) {
        return (DelayActionCreator)super.withName(name);
    }
}

