/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.allocation.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.generator.fluent.allocation.api.IAllocation;
import org.palladiosimulator.generator.fluent.allocation.api.IAllocationAddition;
import org.palladiosimulator.generator.fluent.allocation.structure.AllocationContextCreator;
import org.palladiosimulator.generator.fluent.allocation.structure.AllocationEntity;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.shared.validate.IModelValidator;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;

public class AllocationCreator
extends AllocationEntity
implements IAllocation {
    private final IModelValidator validator;
    private final List<AllocationContext> allocationContexts = new ArrayList<AllocationContext>();
    private ResourceEnvironment resourceEnvironment;
    private System system;

    public AllocationCreator(IModelValidator validator) {
        this.validator = validator;
    }

    protected Allocation build() {
        Allocation allocation = AllocationFactory.eINSTANCE.createAllocation();
        if (this.name != null) {
            allocation.setEntityName(this.name);
        }
        allocation.getAllocationContexts_Allocation().addAll(this.allocationContexts);
        allocation.setTargetResourceEnvironment_Allocation(this.resourceEnvironment);
        allocation.setSystem_Allocation(this.system);
        return allocation;
    }

    @Override
    public AllocationCreator withName(String name) {
        return (AllocationCreator)super.withName(name);
    }

    @Override
    public Allocation createAllocationNow() {
        Allocation allocation = this.build();
        this.validator.validate((EObject)allocation, this.name);
        return allocation;
    }

    @Override
    public IAllocationAddition withResourceEnvironment(ResourceEnvironment environment) {
        this.resourceEnvironment = IllegalArgumentException.throwIfNull(environment, "The given ResourceEnvironment must not be null");
        return this;
    }

    @Override
    public IAllocationAddition withSystem(System system) {
        this.system = IllegalArgumentException.throwIfNull(system, "The given System must not be null");
        return this;
    }

    @Override
    public IAllocationAddition addToAllocation(AllocationContextCreator allocationContext) {
        IllegalArgumentException.throwIfNull(allocationContext, "The given AllocationContext must not be null");
        this.allocationContexts.add(allocationContext.build());
        return this;
    }

    public AssemblyContext getAssemblyContextByName(String name) throws IllegalArgumentException {
        if (this.system == null) {
            throw new IllegalArgumentException("No AssemblyContext found.");
        }
        return this.system.getAssemblyContexts__ComposedStructure().stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No AssemblyContext with name " + name + " found."));
    }

    public EventChannel getEventChannelByName(String name) throws IllegalArgumentException {
        if (this.system == null) {
            throw new IllegalArgumentException("No EventChannel found.");
        }
        return this.system.getEventChannel__ComposedStructure().stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No EventChannel with name " + name + " found."));
    }

    public ResourceContainer getResourceContainerByName(String name) throws IllegalArgumentException {
        if (this.resourceEnvironment == null) {
            throw new IllegalArgumentException("No ResourceContainer found.");
        }
        return this.resourceEnvironment.getResourceContainer_ResourceEnvironment().stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No ResourceContainer with name " + name + " found."));
    }
}

