/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.interfaces;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryEntity;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Failure;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Primitive;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.ExceptionType;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.ParameterModifier;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class OperationSignatureCreator
extends RepositoryEntity {
    private DataType returnType;
    private final List<Parameter> ownedParameters;
    private final List<FailureType> failureTypes;
    private final List<ExceptionType> exceptionTypes;

    public OperationSignatureCreator(RepositoryCreator repo) {
        this.repository = repo;
        this.ownedParameters = new ArrayList<Parameter>();
        this.failureTypes = new ArrayList<FailureType>();
        this.exceptionTypes = new ArrayList<ExceptionType>();
    }

    @Override
    public OperationSignatureCreator withName(String name) {
        return (OperationSignatureCreator)super.withName(name);
    }

    public OperationSignatureCreator withReturnType(DataType returnType) {
        IllegalArgumentException.throwIfNull(returnType, "returnType must not be null");
        this.returnType = returnType;
        return this;
    }

    public OperationSignatureCreator withReturnType(Primitive returnType) {
        IllegalArgumentException.throwIfNull(returnType, "returnType must not be null");
        PrimitiveDataType primitiveDataType = this.repository.getPrimitiveDataType(returnType);
        return this.withReturnType((DataType)primitiveDataType);
    }

    public OperationSignatureCreator withParameter(String name, Primitive dataType, ParameterModifier modifier) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(dataType, "dataType must not be null");
        PrimitiveDataType dt = this.repository.getPrimitiveDataType(dataType);
        return this.withParameter(name, (DataType)dt, modifier);
    }

    public OperationSignatureCreator withParameter(String name, DataType dataType, ParameterModifier modifier) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(dataType, "dataType must not be null");
        Parameter param = RepositoryFactory.eINSTANCE.createParameter();
        param.setParameterName(name);
        param.setDataType__Parameter(dataType);
        if (modifier != null) {
            param.setModifier__Parameter(modifier);
        }
        this.ownedParameters.add(param);
        this.repository.addParameter(param);
        return this;
    }

    public OperationSignatureCreator withFailureType(FailureType failureType) {
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        this.failureTypes.add(failureType);
        return this;
    }

    public OperationSignatureCreator withFailureType(Failure failureType) {
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        FailureType failure = this.repository.getFailureType(failureType);
        return this.withFailureType(failure);
    }

    public OperationSignatureCreator withExceptionType(ExceptionType exceptionType) {
        IllegalArgumentException.throwIfNull(exceptionType, "exceptionType must not be null");
        this.exceptionTypes.add(exceptionType);
        return this;
    }

    protected OperationSignature build() {
        OperationSignature ops = RepositoryFactory.eINSTANCE.createOperationSignature();
        if (this.name != null) {
            ops.setEntityName(this.name);
        }
        ops.setReturnType__OperationSignature(this.returnType);
        ops.getParameters__OperationSignature().addAll(this.ownedParameters);
        ops.getFailureType().addAll(this.failureTypes);
        ops.getExceptions__Signature().addAll(this.exceptionTypes);
        return ops;
    }
}

