/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.types;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryEntity;
import org.palladiosimulator.pcm.repository.ExceptionType;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class ExceptionTypeCreator
extends RepositoryEntity {
    private String exceptionMessage;

    public ExceptionTypeCreator(RepositoryCreator repo) {
        this.repository = repo;
    }

    @Override
    public ExceptionTypeCreator withName(String name) {
        return (ExceptionTypeCreator)super.withName(name);
    }

    public ExceptionTypeCreator withExceptionMessage(String message) {
        IllegalArgumentException.throwIfNull(message, "message must not be null");
        this.exceptionMessage = message;
        return this;
    }

    public ExceptionType build() {
        ExceptionType exType = RepositoryFactory.eINSTANCE.createExceptionType();
        if (this.name != null) {
            exType.setExceptionName(this.name);
        }
        if (this.exceptionMessage != null) {
            exType.setExceptionMessage(this.exceptionMessage);
        }
        return exType;
    }
}

