/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.resourceenvironment.structure;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ResourceEntity;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ResourceEnvironmentCreator;
import org.palladiosimulator.generator.fluent.shared.structure.CommunicationLinkResource;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;

public class LinkingResourceCreator
extends ResourceEntity {
    private double failureProbability;
    private CommunicationLinkResourceType resourceType;
    private final List<ResourceContainer> linkedContainers = new ArrayList<ResourceContainer>();
    private PCMRandomVariable latencyVariable;
    private PCMRandomVariable throughputVariable;

    public LinkingResourceCreator(ResourceEnvironmentCreator resourceEnvironmentCreator) {
        this.resourceCreator = resourceEnvironmentCreator;
    }

    public LinkingResourceCreator withFailureProbability(double failureProbability) {
        this.failureProbability = failureProbability;
        return this;
    }

    public LinkingResourceCreator withCommunicationLinkResource(CommunicationLinkResource resource) {
        this.resourceType = this.resourceCreator.getCommunicationLinkResource(resource);
        return this;
    }

    public LinkingResourceCreator addLinkedResourceContainer(ResourceContainer container) {
        IllegalArgumentException.throwIfNull(container, "The given ResourceContainer must not be null");
        this.linkedContainers.add(container);
        return this;
    }

    public LinkingResourceCreator addLinkedResourceContainer(String name) throws IllegalArgumentException {
        ResourceContainer container = this.resourceCreator.getResourceContainerByName(name);
        this.linkedContainers.add(container);
        return this;
    }

    public LinkingResourceCreator withLatency(String latency) {
        IllegalArgumentException.throwIfNull(latency, "the given latency must not be null");
        this.latencyVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
        this.latencyVariable.setSpecification(latency);
        return this;
    }

    public LinkingResourceCreator withThroughput(String throughput) {
        IllegalArgumentException.throwIfNull(throughput, "The given throughput must not be null");
        this.throughputVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
        this.throughputVariable.setSpecification(throughput);
        return this;
    }

    @Override
    public LinkingResourceCreator withName(String name) {
        return (LinkingResourceCreator)super.withName(name);
    }

    public LinkingResource build() {
        CommunicationLinkResourceSpecification resourceSpecification = ResourceenvironmentFactory.eINSTANCE.createCommunicationLinkResourceSpecification();
        resourceSpecification.setCommunicationLinkResourceType_CommunicationLinkResourceSpecification(this.resourceType);
        resourceSpecification.setFailureProbability(this.failureProbability);
        resourceSpecification.setLatency_CommunicationLinkResourceSpecification(this.latencyVariable);
        resourceSpecification.setThroughput_CommunicationLinkResourceSpecification(this.throughputVariable);
        LinkingResource resource = ResourceenvironmentFactory.eINSTANCE.createLinkingResource();
        if (this.name != null) {
            resource.setEntityName(this.name);
        }
        resource.setCommunicationLinkResourceSpecifications_LinkingResource(resourceSpecification);
        resource.getConnectedResourceContainers_LinkingResource().addAll(this.linkedContainers);
        return resource;
    }
}

