/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.shared.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.generator.fluent.exceptions.FluentApiException;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.UsageModel;

public final class ModelSaver {
    private static void save(EObject model, String path, String name, String extension) {
        if (model == null) {
            throw new FluentApiException("The EObject that is the root of the saved model cannot be null.");
        }
        if (path == null || path.isBlank() || name == null || name.isBlank() || extension == null || extension.isBlank()) {
            throw new FluentApiException("The elements of the path where the model will be saved with the specified file name and extension must not be blank.");
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        String[] stringArray = new String[]{extension, "xmi"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fe = stringArray[n2];
            rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fe, new XMIResourceFactoryImpl());
            ++n2;
        }
        String fileName = String.valueOf(name.strip()) + "." + extension.strip();
        File file = Paths.get(path.strip(), fileName).toAbsolutePath().normalize().toFile();
        URI uri = URI.createFileURI((String)fileName);
        Resource resource = rs.createResource(uri);
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
        resource.getContents().add((Object)model);
        ((XMIResource)resource).setEncoding("UTF-8");
        Map saveOptions = ((XMIResource)resource).getDefaultSaveOptions();
        saveOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
        saveOptions.put("USE_CACHED_LOOKUP_TABLE", new ArrayList());
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            Throwable throwable = null;
            Object var11_15 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                resource.save((OutputStream)out, saveOptions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FluentApiException(e);
        }
    }

    public static void saveAllocation(Allocation allocation, String path, String name) {
        ModelSaver.save((EObject)allocation, path, name, "allocation");
    }

    public static void saveRepository(Repository repository, String path, String name) {
        ModelSaver.save((EObject)repository, path, name, "repository");
    }

    public static void saveResourceEnvironment(ResourceEnvironment resourceEnvironment, String path, String name) {
        ModelSaver.save((EObject)resourceEnvironment, path, name, "resourceenvironment");
    }

    public static void saveSystem(System system, String path, String name) {
        ModelSaver.save((EObject)system, path, name, "system");
    }

    public static void saveUsageModel(UsageModel usgModel, String path, String name) {
        ModelSaver.save((EObject)usgModel, path, name, "usagemodel");
    }

    private ModelSaver() throws IllegalStateException {
        throw new IllegalStateException("Utility classes cannot be instantiated.");
    }
}

