/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.event;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.event.SinkRoleSelector;
import org.palladiosimulator.generator.fluent.system.structure.connector.event.SourceRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyEventConnector;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;

public class AssemblyEventConnectorCreator
extends AbstractConnectorCreator {
    private AssemblyContext sourceContext;
    private SourceRole sourceRole;
    private AssemblyContext sinkContext;
    private SinkRole sinkRole;

    public AssemblyEventConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public SourceRoleSelector<AssemblyEventConnectorCreator> withSourceAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new SourceRoleSelector<AssemblyEventConnectorCreator>((context1, role) -> {
            this.sourceContext = context1;
            this.sourceRole = role;
            return this;
        }, context);
    }

    public SourceRoleSelector<AssemblyEventConnectorCreator> withSourceAssemblyContext(String name) throws NoSuchElementException {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withSourceAssemblyContext(context);
    }

    public SinkRoleSelector<AssemblyEventConnectorCreator> withSinkAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new SinkRoleSelector<AssemblyEventConnectorCreator>((context1, role) -> {
            this.sinkContext = context1;
            this.sinkRole = role;
            return this;
        }, context);
    }

    public SinkRoleSelector<AssemblyEventConnectorCreator> withSinkAssemblyContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withSinkAssemblyContext(context);
    }

    public AssemblyEventConnector build() {
        AssemblyEventConnector connector = CompositionFactory.eINSTANCE.createAssemblyEventConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setSourceAssemblyContext__AssemblyEventConnector(this.sourceContext);
        connector.setSourceRole__AssemblyEventConnector(this.sourceRole);
        connector.setSinkAssemblyContext__AssemblyEventConnector(this.sinkContext);
        connector.setSinkRole__AssemblyEventConnector(this.sinkRole);
        return connector;
    }

    @Override
    public AssemblyEventConnectorCreator withName(String name) {
        return (AssemblyEventConnectorCreator)super.withName(name);
    }
}

