/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.operation;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.operation.OperationRequiredRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;

public class RequiredDelegationConnectorCreator
extends AbstractConnectorCreator {
    private OperationRequiredRole outerRequiredRole;
    private OperationRequiredRole innerRequiredRole;
    private AssemblyContext requringAssemblyContext;

    public RequiredDelegationConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public RequiredDelegationConnectorCreator withOuterRequiredRole(OperationRequiredRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.outerRequiredRole = role;
        return this;
    }

    public RequiredDelegationConnectorCreator withOuterRequiredRole(String name) throws NoSuchElementException {
        OperationRequiredRole role = this.system.getSystemOperationRequiredRoleByName(name);
        return this.withOuterRequiredRole(role);
    }

    public OperationRequiredRoleSelector<RequiredDelegationConnectorCreator> withRequiringContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new OperationRequiredRoleSelector<RequiredDelegationConnectorCreator>((context1, role) -> {
            this.requringAssemblyContext = context1;
            this.innerRequiredRole = role;
            return this;
        }, context);
    }

    public OperationRequiredRoleSelector<RequiredDelegationConnectorCreator> withRequiringContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withRequiringContext(context);
    }

    public RequiredDelegationConnector build() {
        RequiredDelegationConnector connector = CompositionFactory.eINSTANCE.createRequiredDelegationConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setAssemblyContext_RequiredDelegationConnector(this.requringAssemblyContext);
        connector.setOuterRequiredRole_RequiredDelegationConnector(this.outerRequiredRole);
        connector.setInnerRequiredRole_RequiredDelegationConnector(this.innerRequiredRole);
        return connector;
    }

    @Override
    public RequiredDelegationConnectorCreator withName(String name) {
        return (RequiredDelegationConnectorCreator)super.withName(name);
    }
}

