/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.role;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class OperationProvidedRoleCreator
extends SystemEntity {
    private OperationInterface providedInterface;

    public OperationProvidedRoleCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public OperationProvidedRoleCreator withProvidedInterface(OperationInterface operationInterface) {
        IllegalArgumentException.throwIfNull(operationInterface, "The given Interface must not be null.");
        this.providedInterface = operationInterface;
        return this;
    }

    public OperationProvidedRoleCreator withProvidedInterface(String name) throws NoSuchElementException {
        OperationInterface requiredInterface;
        try {
            requiredInterface = (OperationInterface)this.system.getInterfaceByName(name);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("An Interface with name '%s' was found, but it was not an OperationInterface. Please make sure all names are unique.", name), e);
        }
        return this.withProvidedInterface(requiredInterface);
    }

    public OperationProvidedRole build() {
        OperationProvidedRole role = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        if (this.name != null) {
            role.setEntityName(this.name);
        }
        role.setProvidedInterface__OperationProvidedRole(this.providedInterface);
        return role;
    }

    @Override
    public OperationProvidedRoleCreator withName(String name) {
        return (OperationProvidedRoleCreator)super.withName(name);
    }
}

