/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.structure.components;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.usagemodel.structure.UsageModelCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.UsageModelEntity;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.ActionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.StartActionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.StopActionCreator;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;

public class ScenarioBehaviourCreator
extends UsageModelEntity {
    private final List<AbstractUserAction> actions = new ArrayList<AbstractUserAction>();

    public ScenarioBehaviourCreator(UsageModelCreator usgModelCreator) {
        this.usageModelCreator = usgModelCreator;
    }

    public ScenarioBehaviourCreator addToScenarioBehaviour(ActionCreator action) {
        IllegalArgumentException.throwIfNull(action, "The given Action must not be null");
        AbstractUserAction usrAction = action.build();
        this.createActionFlow(usrAction);
        return this;
    }

    private void addStart(AbstractUserAction first) {
        if (first instanceof Start) {
            return;
        }
        StartActionCreator startCreator = new StartActionCreator();
        AbstractUserAction start = ((ActionCreator)startCreator).build();
        start.setSuccessor(first);
        this.actions.add(start);
    }

    private void addStop(AbstractUserAction last) {
        if (last instanceof Stop) {
            return;
        }
        StopActionCreator stopCreator = new StopActionCreator();
        AbstractUserAction stop = ((ActionCreator)stopCreator).build();
        stop.setPredecessor(last);
        this.actions.add(stop);
    }

    private void createActionFlow(AbstractUserAction start) {
        ArrayList<AbstractUserAction> flow = new ArrayList<AbstractUserAction>();
        AbstractUserAction before = start;
        AbstractUserAction current = start;
        this.addStart(current);
        while (current != null) {
            flow.add(current);
            before = current;
            current = current.getSuccessor();
        }
        this.addStop(before);
        this.actions.addAll(flow);
    }

    private void addStartStop() {
        StartActionCreator startCreator = new StartActionCreator();
        AbstractUserAction start = ((ActionCreator)startCreator).build();
        StopActionCreator stopCreator = new StopActionCreator();
        AbstractUserAction stop = ((ActionCreator)stopCreator).build();
        start.setSuccessor(stop);
        this.actions.add(start);
        this.actions.add(stop);
    }

    public ScenarioBehaviour build() {
        ScenarioBehaviour scenBeh = UsagemodelFactory.eINSTANCE.createScenarioBehaviour();
        if (this.name != null) {
            scenBeh.setEntityName(this.name);
        }
        if (this.actions.isEmpty()) {
            this.addStartStop();
        }
        scenBeh.getActions_ScenarioBehaviour().addAll(this.actions);
        return scenBeh;
    }

    @Override
    public ScenarioBehaviourCreator withName(String name) {
        return (ScenarioBehaviourCreator)super.withName(name);
    }
}

