/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.resourceenvironment.structure;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ResourceEnvironmentCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.generator.fluent.shared.structure.SchedulingPolicies;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.resourceenvironment.HDDProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;

public class HddProcessingResourceSpecificationCreator {
    private double mttr;
    private double mttf;
    private int numberOfReplicas;
    private boolean isRequiredByContainer = false;
    private SchedulingPolicy schedulingPolicy;
    private ProcessingResourceType processingResourceType;
    private final ResourceEnvironmentCreator resourceCreator;
    private PCMRandomVariable processingRateVariable;
    private PCMRandomVariable writeProcessingRate;
    private PCMRandomVariable readProcessingRate;

    public HddProcessingResourceSpecificationCreator(ResourceEnvironmentCreator resourceCreator) {
        this.resourceCreator = resourceCreator;
    }

    public HddProcessingResourceSpecificationCreator withMttr(double mttr) {
        this.mttr = mttr;
        return this;
    }

    public HddProcessingResourceSpecificationCreator withMttf(double mttf) {
        this.mttf = mttf;
        return this;
    }

    public HddProcessingResourceSpecificationCreator withNumberOfReplicas(int numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
        return this;
    }

    public HddProcessingResourceSpecificationCreator isRequiredByContainer() {
        this.isRequiredByContainer = true;
        return this;
    }

    public HddProcessingResourceSpecificationCreator withSchedulingPolicy(SchedulingPolicies policy) {
        this.schedulingPolicy = this.resourceCreator.getSchedulingPolicy(policy);
        return this;
    }

    public HddProcessingResourceSpecificationCreator withProcessingResourceType(ProcessingResource resource) {
        this.processingResourceType = this.resourceCreator.getProcessingResource(resource);
        return this;
    }

    public HddProcessingResourceSpecificationCreator withProcessingRate(String processingRate) {
        IllegalArgumentException.throwIfNull(processingRate, "The given processingRate must not be null");
        PCMRandomVariable randomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
        randomVariable.setSpecification(processingRate);
        this.processingRateVariable = randomVariable;
        return this;
    }

    public HddProcessingResourceSpecificationCreator withWriteProcessingRate(String writeProcessingRate) {
        IllegalArgumentException.throwIfNull(writeProcessingRate, "The given writeProcessingRate must not be null");
        PCMRandomVariable randomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
        randomVariable.setSpecification(writeProcessingRate);
        this.writeProcessingRate = randomVariable;
        return this;
    }

    public HddProcessingResourceSpecificationCreator withReadProcessingRate(String readProcessingRate) {
        IllegalArgumentException.throwIfNull(readProcessingRate, "The given readProcessingRate must not be null");
        PCMRandomVariable randomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
        randomVariable.setSpecification(readProcessingRate);
        this.readProcessingRate = randomVariable;
        return this;
    }

    public HDDProcessingResourceSpecification build() {
        HDDProcessingResourceSpecification prs = ResourceenvironmentFactory.eINSTANCE.createHDDProcessingResourceSpecification();
        prs.setMTTR(this.mttr);
        prs.setMTTF(this.mttf);
        prs.setNumberOfReplicas(this.numberOfReplicas);
        prs.setRequiredByContainer(this.isRequiredByContainer);
        prs.setSchedulingPolicy(this.schedulingPolicy);
        prs.setActiveResourceType_ActiveResourceSpecification(this.processingResourceType);
        prs.setProcessingRate_ProcessingResourceSpecification(this.processingRateVariable);
        prs.setWriteProcessingRate(this.writeProcessingRate);
        prs.setReadProcessingRate(this.readProcessingRate);
        return prs;
    }
}

