/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.operation;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.operation.OperationProvidedRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;

public class ProvidedDelegationConnectorCreator
extends AbstractConnectorCreator {
    private OperationProvidedRole outerProvidedRole;
    private OperationProvidedRole innerProvidedRole;
    private AssemblyContext providingAssemblyContext;

    public ProvidedDelegationConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public ProvidedDelegationConnectorCreator withOuterProvidedRole(OperationProvidedRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.outerProvidedRole = role;
        return this;
    }

    public ProvidedDelegationConnectorCreator withOuterProvidedRole(String name) throws NoSuchElementException {
        OperationProvidedRole role = this.system.getSystemOperationProvidedRoleByName(name);
        return this.withOuterProvidedRole(role);
    }

    public OperationProvidedRoleSelector<ProvidedDelegationConnectorCreator> withProvidingContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new OperationProvidedRoleSelector<ProvidedDelegationConnectorCreator>((context1, role) -> {
            this.providingAssemblyContext = context1;
            this.innerProvidedRole = role;
            return this;
        }, context);
    }

    public OperationProvidedRoleSelector<ProvidedDelegationConnectorCreator> withProvidingContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withProvidingContext(context);
    }

    public ProvidedDelegationConnector build() {
        ProvidedDelegationConnector connector = CompositionFactory.eINSTANCE.createProvidedDelegationConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setAssemblyContext_ProvidedDelegationConnector(this.providingAssemblyContext);
        connector.setOuterProvidedRole_ProvidedDelegationConnector(this.outerProvidedRole);
        connector.setInnerProvidedRole_ProvidedDelegationConnector(this.innerProvidedRole);
        return connector;
    }

    @Override
    public ProvidedDelegationConnectorCreator withName(String name) {
        return (ProvidedDelegationConnectorCreator)super.withName(name);
    }
}

