/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.resource;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.ResourceRequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;

public class ResourceRequiredDelegationConnectorCreator {
    private final SystemCreator system;
    private ResourceRequiredRole outerRequiredRole;
    private ResourceRequiredRole innerRequiredRole;

    public ResourceRequiredDelegationConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public ResourceRequiredDelegationConnectorCreator withOuterRequiredRole(ResourceRequiredRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.outerRequiredRole = role;
        return this;
    }

    public ResourceRequiredDelegationConnectorCreator withOuterRequiredRole(String name) throws NoSuchElementException {
        ResourceRequiredRole role = this.system.getSystemResourceRequiredRoleByName(name);
        return this.withOuterRequiredRole(role);
    }

    public ResourceRequiredDelegationConnectorCreator withInnerRequiredRole(ResourceRequiredRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.innerRequiredRole = role;
        return this;
    }

    public ResourceRequiredDelegationConnectorCreator withInnerRequiredRole(String name) {
        ResourceRequiredRole role = this.system.getResourceRequiredRoleByName(name);
        return this.withInnerRequiredRole(role);
    }

    public ResourceRequiredDelegationConnector build() {
        ResourceRequiredDelegationConnector connector = CompositionFactory.eINSTANCE.createResourceRequiredDelegationConnector();
        connector.setOuterResourceRequiredRole_ResourceRequiredDelegationConnector(this.outerRequiredRole);
        connector.setInnerResourceRequiredRole_ResourceRequiredDelegationConnector(this.innerRequiredRole);
        return connector;
    }
}

