/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.role;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.SinkRole;

public class SinkRoleCreator
extends SystemEntity {
    private EventGroup eventGroup;

    public SinkRoleCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public SinkRoleCreator withEventGroup(EventGroup eventGroup) {
        IllegalArgumentException.throwIfNull(eventGroup, "The given EventGroup must not be null.");
        this.eventGroup = eventGroup;
        return this;
    }

    public SinkRoleCreator withEventGroup(String name) throws NoSuchElementException {
        EventGroup group;
        try {
            group = (EventGroup)this.system.getInterfaceByName(name);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("An Interface with name '%s' was found, but it was not an EventGroup. Please make sure all names are unique.", name), e);
        }
        return this.withEventGroup(group);
    }

    public SinkRole build() {
        SinkRole role = RepositoryFactory.eINSTANCE.createSinkRole();
        if (this.name != null) {
            role.setEntityName(this.name);
        }
        role.setEventGroup__SinkRole(this.eventGroup);
        return role;
    }

    @Override
    public SinkRoleCreator withName(String name) {
        return (SinkRoleCreator)super.withName(name);
    }
}

