/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.role;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.SourceRole;

public class SourceRoleCreator
extends SystemEntity {
    private EventGroup eventGroup;

    public SourceRoleCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public SourceRoleCreator withEventGroup(EventGroup eventGroup) {
        IllegalArgumentException.throwIfNull(eventGroup, "The given EventGroup must not be null.");
        this.eventGroup = eventGroup;
        return this;
    }

    public SourceRoleCreator withEventGroup(String name) throws NoSuchElementException {
        EventGroup group;
        try {
            group = (EventGroup)this.system.getInterfaceByName(name);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("An Interface with name '%s' was found, but it was not an EventGroup. Please make sure all names are unique.", name), e);
        }
        return this.withEventGroup(group);
    }

    public SourceRole build() {
        SourceRole role = RepositoryFactory.eINSTANCE.createSourceRole();
        if (this.name != null) {
            role.setEntityName(this.name);
        }
        role.setEventGroup__SourceRole(this.eventGroup);
        return role;
    }

    @Override
    public SourceRoleCreator withName(String name) {
        return (SourceRoleCreator)super.withName(name);
    }
}

