/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.api.seff.RecoverySeff;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryAction;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryActionBehaviour;
import org.palladiosimulator.pcm.seff.seff_reliability.SeffReliabilityFactory;

public class RecoveryActionCreator
extends GeneralAction {
    private RecoveryActionBehaviour primary;
    private final List<RecoveryActionBehaviour> otherBehaviours;

    protected RecoveryActionCreator(SeffCreator seff, RepositoryCreator repo) {
        this.repository = repo;
        this.seff = seff;
        this.otherBehaviours = new ArrayList<RecoveryActionBehaviour>();
    }

    @Override
    public RecoveryActionCreator withName(String name) {
        return (RecoveryActionCreator)super.withName(name);
    }

    public RecoveryActionCreator withPrimaryBehaviour(RecoverySeff recoveryActionBehaviour) {
        RecoveryActionBehaviour build;
        IllegalArgumentException.throwIfNull(recoveryActionBehaviour, "recoveryActionBehaviour must not be null");
        this.primary = build = recoveryActionBehaviour.buildRecoveryBehaviour();
        this.repository.addRecoveryActionBehaviour(build);
        return this;
    }

    public RecoveryActionCreator withAlternativeBehaviour(RecoverySeff recoveryActionBehaviour) {
        IllegalArgumentException.throwIfNull(recoveryActionBehaviour, "recoveryActionBehaviour must not be null");
        RecoveryActionBehaviour buildRecoveryBehaviour = recoveryActionBehaviour.buildRecoveryBehaviour();
        this.otherBehaviours.add(buildRecoveryBehaviour);
        this.repository.addRecoveryActionBehaviour(buildRecoveryBehaviour);
        return this;
    }

    @Override
    public RecoveryActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (RecoveryActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public RecoveryActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (RecoveryActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public RecoveryActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (RecoveryActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected RecoveryAction build() {
        RecoveryAction action = SeffReliabilityFactory.eINSTANCE.createRecoveryAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        if (this.primary != null) {
            action.setPrimaryBehaviour__RecoveryAction(this.primary);
        }
        action.getRecoveryActionBehaviours__RecoveryAction().addAll(this.otherBehaviours);
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        return action;
    }
}

