/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.generator.fluent.exceptions.FluentApiException;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.repository.api.Repo;
import org.palladiosimulator.generator.fluent.repository.api.RepoAddition;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryEntity;
import org.palladiosimulator.generator.fluent.repository.structure.components.Component;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.Interface;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Failure;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Primitive;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.repository.structure.types.CompositeDataTypeCreator;
import org.palladiosimulator.generator.fluent.repository.structure.types.ExceptionTypeCreator;
import org.palladiosimulator.generator.fluent.repository.structure.types.ResourceTimeoutFailureTypeCreator;
import org.palladiosimulator.generator.fluent.shared.structure.CommunicationLinkResource;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.generator.fluent.shared.validate.IModelValidator;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.ResourceTimeoutFailureType;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompleteComponentType;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.ExceptionType;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.PrimitiveTypeEnum;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidesComponentType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceInterface;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryAction;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryActionBehaviour;
import org.palladiosimulator.pcm.subsystem.SubSystem;

public class RepositoryCreator
extends RepositoryEntity
implements Repo,
RepoAddition {
    private final Logger logger;
    private String description;
    private final IModelValidator validator;
    private final List<Repository> imports = new ArrayList<Repository>();
    private final List<DataType> importedDataTypes = new ArrayList<DataType>();
    private final List<FailureType> importedFailureTypes = new ArrayList<FailureType>();
    private final List<RepositoryComponent> importedComponents = new ArrayList<RepositoryComponent>();
    private final List<org.palladiosimulator.pcm.repository.Interface> importedInterfaces = new ArrayList<org.palladiosimulator.pcm.repository.Interface>();
    private final List<DataType> dataTypes = new ArrayList<DataType>();
    private final Map<Primitive, PrimitiveDataType> internalPrimitives = new HashMap<Primitive, PrimitiveDataType>();
    private final Map<ProcessingResource, ProcessingResourceType> internalProcessingResources = new HashMap<ProcessingResource, ProcessingResourceType>();
    private final Map<ResourceSignature, org.palladiosimulator.pcm.resourcetype.ResourceSignature> internalResourceSignatures = new HashMap<ResourceSignature, org.palladiosimulator.pcm.resourcetype.ResourceSignature>();
    private final Map<CommunicationLinkResource, CommunicationLinkResourceType> internalCommunicationLinkResources = new HashMap<CommunicationLinkResource, CommunicationLinkResourceType>();
    private final Map<org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface, ResourceInterface> internalResourceInterfaces = new HashMap<org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface, ResourceInterface>();
    private final Map<Failure, FailureType> internalFailureTypes = new HashMap<Failure, FailureType>();
    private final List<FailureType> failureTypes = new ArrayList<FailureType>();
    private final List<ExceptionType> exceptionTypes;
    private final List<org.palladiosimulator.pcm.repository.Interface> interfaces = new ArrayList<org.palladiosimulator.pcm.repository.Interface>();
    private final List<RepositoryComponent> components = new ArrayList<RepositoryComponent>();
    private final List<ProvidedRole> providedRoles = new ArrayList<ProvidedRole>();
    private final List<RequiredRole> requiredRoles = new ArrayList<RequiredRole>();
    private final List<ResourceRequiredRole> resourceRequiredRoles = new ArrayList<ResourceRequiredRole>();
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final List<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
    private final List<EventChannel> eventChannels = new ArrayList<EventChannel>();
    private final List<Connector> connectors = new ArrayList<Connector>();
    private final List<RecoveryActionBehaviour> behaviours = new ArrayList<RecoveryActionBehaviour>();
    private final List<PassiveResource> passiveResources = new ArrayList<PassiveResource>();
    private final List<Signature> signatures;

    public RepositoryCreator(Repository primitiveDataTypes, ResourceRepository resourceTypes, Repository failureTypes, Logger logger, IModelValidator validator) {
        this.exceptionTypes = new ArrayList<ExceptionType>();
        this.signatures = new ArrayList<Signature>();
        this.initPredefinedDataTypesAndResources(primitiveDataTypes, resourceTypes, failureTypes);
        this.logger = logger;
        this.validator = validator;
    }

    private static Repository loadRepository(String uri) {
        return RepositoryCreator.loadRepository(URI.createURI((String)uri));
    }

    private static Repository loadRepository(URI uri) {
        RepositoryPackage.eINSTANCE.eClass();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("repository", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        return (Repository)resource.getContents().get(0);
    }

    private void initPredefinedDataTypesAndResources(Repository primitiveDataTypes, ResourceRepository resourceTypes, Repository failureTypes) {
        PrimitiveDataType p;
        EList dts = primitiveDataTypes.getDataTypes__Repository();
        for (DataType d : dts) {
            p = (PrimitiveDataType)d;
            PrimitiveTypeEnum type = p.getType();
            switch (type) {
                case BOOL: {
                    this.internalPrimitives.put(Primitive.BOOLEAN, p);
                    break;
                }
                case BYTE: {
                    this.internalPrimitives.put(Primitive.BYTE, p);
                    break;
                }
                case CHAR: {
                    this.internalPrimitives.put(Primitive.CHAR, p);
                    break;
                }
                case DOUBLE: {
                    this.internalPrimitives.put(Primitive.DOUBLE, p);
                    break;
                }
                case INT: {
                    this.internalPrimitives.put(Primitive.INTEGER, p);
                    break;
                }
                case LONG: {
                    this.internalPrimitives.put(Primitive.LONG, p);
                    break;
                }
                case STRING: {
                    this.internalPrimitives.put(Primitive.STRING, p);
                }
            }
        }
        for (ResourceType resourceType : resourceTypes.getAvailableResourceTypes_ResourceRepository()) {
            block65: {
                ResourceType resourceType2 = resourceType;
                if (!(resourceType2 instanceof ProcessingResourceType) || (p = (ProcessingResourceType)resourceType2) != (ProcessingResourceType)resourceType2) break block65;
                switch (p.getEntityName()) {
                    case "CPU": {
                        this.internalProcessingResources.put(ProcessingResource.CPU, (ProcessingResourceType)p);
                        break;
                    }
                    case "HDD": {
                        this.internalProcessingResources.put(ProcessingResource.HDD, (ProcessingResourceType)p);
                        break;
                    }
                    case "DELAY": {
                        this.internalProcessingResources.put(ProcessingResource.DELAY, (ProcessingResourceType)p);
                        break;
                    }
                    default: {
                        this.logger.warning("Unexpected Processing Resource Type.");
                        break;
                    }
                }
                continue;
            }
            if (!(resourceType instanceof CommunicationLinkResourceType)) continue;
            this.internalCommunicationLinkResources.put(CommunicationLinkResource.LAN, (CommunicationLinkResourceType)resourceType);
        }
        for (ResourceInterface resourceInterface : resourceTypes.getResourceInterfaces__ResourceRepository()) {
            switch (resourceInterface.getEntityName()) {
                case "CpuInterface": {
                    this.internalResourceInterfaces.put(org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface.CPU, resourceInterface);
                    break;
                }
                case "HddInterface": {
                    this.internalResourceInterfaces.put(org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface.HDD, resourceInterface);
                    break;
                }
                default: {
                    this.logger.warning("Unexpected Resource Interface.");
                }
            }
            for (org.palladiosimulator.pcm.resourcetype.ResourceSignature s : resourceInterface.getResourceSignatures__ResourceInterface()) {
                switch (s.getEntityName()) {
                    case "process": {
                        this.internalResourceSignatures.put(ResourceSignature.PROCESS, s);
                        break;
                    }
                    case "read": {
                        this.internalResourceSignatures.put(ResourceSignature.READ, s);
                        break;
                    }
                    case "write": {
                        this.internalResourceSignatures.put(ResourceSignature.WRITE, s);
                        break;
                    }
                    default: {
                        this.logger.warning("Unexpected Resource Signature.");
                    }
                }
            }
        }
        EList failures = failureTypes.getFailureTypes__Repository();
        for (FailureType f : failures) {
            block69: {
                if (f instanceof SoftwareInducedFailureType) {
                    this.internalFailureTypes.putIfAbsent(Failure.SOFTWARE, f);
                    continue;
                }
                if (f instanceof NetworkInducedFailureType) {
                    this.internalFailureTypes.putIfAbsent(Failure.NETWORK_LAN, f);
                    continue;
                }
                if (!(f instanceof HardwareInducedFailureType)) break block69;
                switch (f.getEntityName().toLowerCase(Locale.US)) {
                    case "hardwareinducedfailure (cpu)": {
                        this.internalFailureTypes.putIfAbsent(Failure.HARDWARE_CPU, f);
                        break;
                    }
                    case "hardwareinducedfailure (hdd)": {
                        this.internalFailureTypes.putIfAbsent(Failure.HARDWARE_HDD, f);
                        break;
                    }
                    case "hardwareinducedfailure (delay)": {
                        this.internalFailureTypes.putIfAbsent(Failure.HARDWARE_DELAY, f);
                        break;
                    }
                    default: {
                        this.logger.warning("Unexpected failure type while reading internal failure types.");
                        break;
                    }
                }
                continue;
            }
            this.logger.warning("Unexpected failure type while reading internal failure types.");
        }
    }

    @Override
    public RepositoryCreator withName(String name) {
        return (RepositoryCreator)super.withName(name);
    }

    @Override
    public RepositoryCreator withDescription(String description) {
        IllegalArgumentException.throwIfNull(description, "description must not be null");
        this.description = description;
        return this;
    }

    @Override
    public Repo withImportedResource(URI uri) {
        IllegalArgumentException.throwIfNull(uri, "URI must not be null.");
        if (!"repository".equals(uri.fileExtension().toLowerCase(Locale.US))) {
            throw new IllegalArgumentException("The specified URI must lead to a .repository file");
        }
        Repository imported = RepositoryCreator.loadRepository(uri);
        return this.withImportedResource(imported);
    }

    @Override
    public Repo withImportedResource(String path) {
        IllegalArgumentException.throwIfNull(path, "path must not be null.");
        if (!path.toLowerCase(Locale.US).endsWith(".repository")) {
            throw new IllegalArgumentException("The specified path must lead to a .repository file");
        }
        Repository imported = RepositoryCreator.loadRepository(path);
        return this.withImportedResource(imported);
    }

    @Override
    public Repo withImportedResource(Repository repository) {
        this.imports.add(IllegalArgumentException.throwIfNull(repository, "repository must not be null"));
        this.importedDataTypes.addAll((Collection<DataType>)repository.getDataTypes__Repository());
        this.importedFailureTypes.addAll((Collection<FailureType>)repository.getFailureTypes__Repository());
        this.importedComponents.addAll((Collection<RepositoryComponent>)repository.getComponents__Repository());
        this.importedInterfaces.addAll((Collection<org.palladiosimulator.pcm.repository.Interface>)repository.getInterfaces__Repository());
        return this;
    }

    @Override
    public RepoAddition addToRepository(CollectionDataType collectionDataType) {
        this.dataTypes.add((DataType)IllegalArgumentException.throwIfNull(collectionDataType, "collectionDataType must not be null"));
        return this;
    }

    @Override
    public RepoAddition addToRepository(CompositeDataTypeCreator compositeDataType) {
        IllegalArgumentException.throwIfNull(compositeDataType, "compositeDataType must not be null");
        CompositeDataType dataType = compositeDataType.build();
        this.dataTypes.add((DataType)dataType);
        return this;
    }

    @Override
    public RepoAddition addToRepository(FailureType failureType) {
        this.failureTypes.add(IllegalArgumentException.throwIfNull(failureType, "failureType must not be null"));
        return this;
    }

    @Override
    public RepoAddition addToRepository(ResourceTimeoutFailureTypeCreator failureType) {
        this.failureTypes.add(IllegalArgumentException.throwIfNull(failureType, "failureType must not be null").build());
        return this;
    }

    @Override
    public RepoAddition addToRepository(ExceptionTypeCreator exceptionType) {
        this.exceptionTypes.add(IllegalArgumentException.throwIfNull(exceptionType, "exceptionType must not be null").build());
        return this;
    }

    @Override
    public RepoAddition addToRepository(Interface interfce) {
        this.interfaces.add(IllegalArgumentException.throwIfNull(interfce, "interfce must not be null").build());
        return this;
    }

    @Override
    public RepoAddition addToRepository(Component component) {
        this.components.add(IllegalArgumentException.throwIfNull(component, "component must not be null").build());
        return this;
    }

    @Override
    public RepoAddition addToRepository(RepositoryComponent component) {
        this.components.add(IllegalArgumentException.throwIfNull(component, "component must not be null"));
        return this;
    }

    protected Repository build() {
        Repository repo = RepositoryFactory.eINSTANCE.createRepository();
        if (this.name != null) {
            repo.setEntityName(this.name);
        }
        if (this.description != null) {
            repo.setRepositoryDescription(this.description);
        }
        repo.getDataTypes__Repository().addAll(this.dataTypes);
        repo.getInterfaces__Repository().addAll(this.interfaces);
        repo.getComponents__Repository().addAll(this.components);
        return repo;
    }

    @Override
    public Repository createRepositoryNow() {
        Repository repo = this.build();
        this.validator.validate((EObject)repo, this.name);
        return repo;
    }

    private Repository getRepositoryByName(String name) {
        List collect = this.imports.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than repository with name '" + name + "' found.");
        }
        return (Repository)collect.get(0);
    }

    public PrimitiveDataType getPrimitiveDataType(Primitive primitive) {
        IllegalArgumentException.throwIfNull(primitive, "primitive must not be null");
        return this.internalPrimitives.get((Object)primitive);
    }

    public PrimitiveDataType getPrimitiveDataType(String name) throws NoSuchElementException {
        String adjustedName;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        switch (adjustedName = name.toUpperCase(Locale.US)) {
            case "INT": {
                return this.internalPrimitives.get((Object)Primitive.INTEGER);
            }
            case "BOOL": {
                return this.internalPrimitives.get((Object)Primitive.BOOLEAN);
            }
        }
        try {
            Primitive valueOf = Primitive.valueOf(adjustedName);
            return this.internalPrimitives.get((Object)valueOf);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new NoSuchElementException(String.format("A primitive data type named '%s' was not found.", name), e);
        }
    }

    public CompositeDataType getCompositeDataType(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new NoSuchElementException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getDataTypes__Repository().stream().filter(d -> d instanceof CompositeDataType).map(d -> (CompositeDataType)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.dataTypes.stream().filter(d -> d instanceof CompositeDataType).map(d -> (CompositeDataType)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getCompositeDataTypeFromList(actualName, collect);
    }

    private CompositeDataType getCompositeDataTypeFromList(String name, List<CompositeDataType> dataTypes) {
        List collect = dataTypes.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one composite data type with name '" + name + "' found.");
        }
        return (CompositeDataType)collect.get(0);
    }

    public DataType getDataType(String name) throws NoSuchElementException {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String[] split = name.split("\\.");
        if (split.length == 2) {
            String entityName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            return this.getDataTypeFromList(entityName, (List<DataType>)r.getDataTypes__Repository());
        }
        if (split.length == 1) {
            return this.getDataTypeFromList(name, this.dataTypes);
        }
        throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
    }

    private DataType getDataTypeFromList(String name, List<DataType> dataTypes) throws NoSuchElementException {
        ArrayList collect = new ArrayList();
        List collectColl = dataTypes.stream().filter(d -> d instanceof CollectionDataType).map(d -> (CollectionDataType)d).filter(d -> d.getEntityName() != null && d.getEntityName().equals(name)).collect(Collectors.toList());
        List collectComp = dataTypes.stream().filter(d -> d instanceof CompositeDataType).map(d -> (CompositeDataType)d).filter(d -> d.getEntityName() != null && d.getEntityName().equals(name)).collect(Collectors.toList());
        collect.addAll(collectColl);
        collect.addAll(collectComp);
        if (collect.isEmpty()) {
            return this.getPrimitiveDataType(name);
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one data type with name '" + name + "' found.");
        }
        return (DataType)collect.get(0);
    }

    public FailureType getFailureType(Failure failure) {
        IllegalArgumentException.throwIfNull(failure, "failure must not be null");
        return this.internalFailureTypes.get((Object)failure);
    }

    public FailureType getFailureType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String[] split = name.split("\\.");
        if (split.length == 2) {
            String entityName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            return this.getFailureTypeFromList(entityName, (List<FailureType>)r.getFailureTypes__Repository());
        }
        if (split.length == 1) {
            return this.getFailureTypeFromList(name, this.failureTypes);
        }
        throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
    }

    private FailureType getFailureTypeFromList(String name, List<FailureType> failureTypes) {
        List collect = failureTypes.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        List collect2 = this.internalFailureTypes.values().stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        collect.addAll(collect2);
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one failure type with name '" + name + "' found.");
        }
        return (FailureType)collect.get(0);
    }

    public ResourceTimeoutFailureType getResourceTimeoutFailureType(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getFailureTypes__Repository().stream().filter(d -> d instanceof ResourceTimeoutFailureType).map(d -> (ResourceTimeoutFailureType)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.failureTypes.stream().filter(d -> d instanceof ResourceTimeoutFailureType).map(d -> (ResourceTimeoutFailureType)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getResourceTimeoutFailureTypeFromList(actualName, collect);
    }

    private ResourceTimeoutFailureType getResourceTimeoutFailureTypeFromList(String name, List<ResourceTimeoutFailureType> failureTypes) {
        List collect = failureTypes.stream().filter(b -> b.getEntityName() != null && b.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one resource timeout failure type with name '" + name + "' found.");
        }
        return (ResourceTimeoutFailureType)collect.get(0);
    }

    public ExceptionType getExceptionType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        List collect = this.exceptionTypes.stream().filter(c -> c.getExceptionName() != null && c.getExceptionName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one component with name '" + name + "' found.");
        }
        return (ExceptionType)collect.get(0);
    }

    public ProcessingResourceType getProcessingResourceType(ProcessingResource processingResource) {
        IllegalArgumentException.throwIfNull(processingResource, "processingResource must not be null");
        return this.internalProcessingResources.get((Object)processingResource);
    }

    public CommunicationLinkResourceType getCommunicationLinkResource(CommunicationLinkResource communicationLinkResource) {
        IllegalArgumentException.throwIfNull(communicationLinkResource, "communicationLinkResource must not be null");
        return this.internalCommunicationLinkResources.get((Object)communicationLinkResource);
    }

    public ResourceInterface getResourceInterface(org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface resourceInterface) {
        IllegalArgumentException.throwIfNull(resourceInterface, "resourceInterface must not be null");
        return this.internalResourceInterfaces.get((Object)resourceInterface);
    }

    public org.palladiosimulator.pcm.resourcetype.ResourceSignature getResourceSignature(ResourceSignature resourceSignature) {
        IllegalArgumentException.throwIfNull(resourceSignature, "resourceSignature must not be null");
        return this.internalResourceSignatures.get((Object)resourceSignature);
    }

    public RepositoryComponent getComponent(String name) {
        EList collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getComponents__Repository();
        } else if (split.length == 1) {
            collect = this.components;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getComponentFromList(actualName, (List<RepositoryComponent>)collect);
    }

    private RepositoryComponent getComponentFromList(String name, List<RepositoryComponent> components) {
        List collect = components.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one component with name '" + name + "' found.");
        }
        return (RepositoryComponent)collect.get(0);
    }

    public BasicComponent getBasicComponent(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getComponents__Repository().stream().filter(d -> d instanceof BasicComponent).map(d -> (BasicComponent)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.components.stream().filter(d -> d instanceof BasicComponent).map(d -> (BasicComponent)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getBasicComponentFromList(actualName, collect);
    }

    private BasicComponent getBasicComponentFromList(String name, List<BasicComponent> components) {
        List collect = components.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one basic component with name '" + name + "' found.");
        }
        return (BasicComponent)collect.get(0);
    }

    public CompositeComponent getCompositeComponent(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getComponents__Repository().stream().filter(d -> d instanceof CompositeComponent).map(d -> (CompositeComponent)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.components.stream().filter(d -> d instanceof CompositeComponent).map(d -> (CompositeComponent)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getCompositeComponentFromList(actualName, collect);
    }

    private CompositeComponent getCompositeComponentFromList(String name, List<CompositeComponent> components) {
        List collect = components.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one composite component with name '" + name + "' found.");
        }
        return (CompositeComponent)collect.get(0);
    }

    public SubSystem getSubsystem(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getComponents__Repository().stream().filter(d -> d instanceof SubSystem).map(d -> (SubSystem)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.components.stream().filter(d -> d instanceof SubSystem).map(d -> (SubSystem)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getSubsystemFromList(actualName, collect);
    }

    private SubSystem getSubsystemFromList(String name, List<SubSystem> components) {
        List collect = components.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one subsystem with name '" + name + "' found.");
        }
        return (SubSystem)collect.get(0);
    }

    public CompleteComponentType getCompleteComponentType(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getComponents__Repository().stream().filter(d -> d instanceof CompleteComponentType).map(d -> (CompleteComponentType)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.components.stream().filter(d -> d instanceof CompleteComponentType).map(d -> (CompleteComponentType)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getCompleteComponentTypeFromList(actualName, collect);
    }

    private CompleteComponentType getCompleteComponentTypeFromList(String name, List<CompleteComponentType> components) {
        List collect = components.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one complete component type with name '" + name + "' found.");
        }
        return (CompleteComponentType)collect.get(0);
    }

    public ProvidesComponentType getProvidesComponentType(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getComponents__Repository().stream().filter(d -> d instanceof ProvidesComponentType).map(d -> (ProvidesComponentType)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.components.stream().filter(d -> d instanceof ProvidesComponentType).map(d -> (ProvidesComponentType)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getProvidesComponentTypeFromList(actualName, collect);
    }

    private ProvidesComponentType getProvidesComponentTypeFromList(String name, List<ProvidesComponentType> components) {
        List collect = components.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one provides component type with name '" + name + "' found.");
        }
        return (ProvidesComponentType)collect.get(0);
    }

    public org.palladiosimulator.pcm.repository.Interface getInterface(String name) {
        EList collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getInterfaces__Repository();
        } else if (split.length == 1) {
            collect = this.interfaces;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getInterfaceFromList(actualName, (List<org.palladiosimulator.pcm.repository.Interface>)collect);
    }

    private org.palladiosimulator.pcm.repository.Interface getInterfaceFromList(String name, List<org.palladiosimulator.pcm.repository.Interface> interfaces) {
        List collect = interfaces.stream().filter(i -> i.getEntityName() != null && i.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one interface with name '" + name + "' found.");
        }
        return (org.palladiosimulator.pcm.repository.Interface)collect.get(0);
    }

    public OperationInterface getOperationInterface(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getInterfaces__Repository().stream().filter(d -> d instanceof OperationInterface).map(d -> (OperationInterface)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.interfaces.stream().filter(d -> d instanceof OperationInterface).map(d -> (OperationInterface)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getOperationInterfaceFromList(actualName, collect);
    }

    private OperationInterface getOperationInterfaceFromList(String name, List<OperationInterface> interfaces) {
        List collect = interfaces.stream().filter(i -> i.getEntityName() != null && i.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one operation interface with name '" + name + "' found.");
        }
        return (OperationInterface)collect.get(0);
    }

    public InfrastructureInterface getInfrastructureInterface(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getInterfaces__Repository().stream().filter(d -> d instanceof InfrastructureInterface).map(d -> (InfrastructureInterface)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.interfaces.stream().filter(d -> d instanceof InfrastructureInterface).map(d -> (InfrastructureInterface)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getInfrastructureInterfaceFromList(actualName, collect);
    }

    private InfrastructureInterface getInfrastructureInterfaceFromList(String name, List<InfrastructureInterface> interfaces) {
        List collect = interfaces.stream().filter(i -> i.getEntityName() != null && i.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one infrastructure interface with name '" + name + "' found.");
        }
        return (InfrastructureInterface)collect.get(0);
    }

    public EventGroup getEventGroup(String name) {
        List<Object> collect;
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            collect = r.getInterfaces__Repository().stream().filter(d -> d instanceof EventGroup).map(d -> (EventGroup)d).collect(Collectors.toList());
        } else if (split.length == 1) {
            collect = this.interfaces.stream().filter(d -> d instanceof EventGroup).map(d -> (EventGroup)d).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getEventGroupFromList(actualName, collect);
    }

    private EventGroup getEventGroupFromList(String name, List<EventGroup> interfaces) {
        List collect = interfaces.stream().filter(i -> i.getEntityName() != null && i.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one event group with name '" + name + "' found.");
        }
        return (EventGroup)collect.get(0);
    }

    public ProvidedRole getProvidedRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<ProvidedRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r.getComponents__Repository()) {
                collect.addAll((Collection<ProvidedRole>)c.getProvidedRoles_InterfaceProvidingEntity());
            }
        } else if (split.length == 1) {
            collect = this.providedRoles;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getProvidedRoleFromList(actualName, collect);
    }

    private ProvidedRole getProvidedRoleFromList(String name, List<ProvidedRole> providedRoles) {
        List collect = providedRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one provided role with name '" + name + "' found.");
        }
        return (ProvidedRole)collect.get(0);
    }

    public OperationProvidedRole getOperationProvidedRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<OperationProvidedRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r2 = this.getRepositoryByName(split[0]);
            if (r2 == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r2.getComponents__Repository()) {
                collect.addAll(c.getProvidedRoles_InterfaceProvidingEntity().stream().filter(p -> p instanceof OperationProvidedRole).map(p -> (OperationProvidedRole)p).collect(Collectors.toList()));
            }
        } else if (split.length == 1) {
            collect = this.providedRoles.stream().filter(r -> r instanceof OperationProvidedRole).map(r -> (OperationProvidedRole)r).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getOperationProvidedRoleFromList(actualName, collect);
    }

    private OperationProvidedRole getOperationProvidedRoleFromList(String name, List<OperationProvidedRole> providedRoles) {
        List collect = providedRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one operation provided role with name '" + name + "' found.");
        }
        return (OperationProvidedRole)collect.get(0);
    }

    public InfrastructureProvidedRole getInfrastructureProvidedRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<InfrastructureProvidedRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r2 = this.getRepositoryByName(split[0]);
            if (r2 == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r2.getComponents__Repository()) {
                collect.addAll(c.getProvidedRoles_InterfaceProvidingEntity().stream().filter(p -> p instanceof InfrastructureProvidedRole).map(p -> (InfrastructureProvidedRole)p).collect(Collectors.toList()));
            }
        } else if (split.length == 1) {
            collect = this.providedRoles.stream().filter(r -> r instanceof InfrastructureProvidedRole).map(r -> (InfrastructureProvidedRole)r).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getInfrastructureProvidedRoleFromList(actualName, collect);
    }

    private InfrastructureProvidedRole getInfrastructureProvidedRoleFromList(String name, List<InfrastructureProvidedRole> providedRoles) {
        List collect = providedRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one infrastructure provided role with name '" + name + "' found.");
        }
        return (InfrastructureProvidedRole)collect.get(0);
    }

    public SinkRole getSinkRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<SinkRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r2 = this.getRepositoryByName(split[0]);
            if (r2 == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r2.getComponents__Repository()) {
                collect.addAll(c.getProvidedRoles_InterfaceProvidingEntity().stream().filter(p -> p instanceof SinkRole).map(p -> (SinkRole)p).collect(Collectors.toList()));
            }
        } else if (split.length == 1) {
            collect = this.providedRoles.stream().filter(r -> r instanceof SinkRole).map(r -> (SinkRole)r).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getSinkRoleFromList(actualName, collect);
    }

    private SinkRole getSinkRoleFromList(String name, List<SinkRole> providedRoles) {
        List collect = providedRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one sink role with name '" + name + "' found.");
        }
        return (SinkRole)collect.get(0);
    }

    public RequiredRole getRequiredRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<RequiredRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r.getComponents__Repository()) {
                collect.addAll((Collection<RequiredRole>)c.getRequiredRoles_InterfaceRequiringEntity());
            }
        } else if (split.length == 1) {
            collect = this.requiredRoles;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getRequiredRoleFromList(actualName, collect);
    }

    private RequiredRole getRequiredRoleFromList(String name, List<RequiredRole> requiredRoles) {
        List collect = requiredRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one required role with name '" + name + "' found.");
        }
        return (RequiredRole)collect.get(0);
    }

    public OperationRequiredRole getOperationRequiredRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<OperationRequiredRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r2 = this.getRepositoryByName(split[0]);
            if (r2 == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r2.getComponents__Repository()) {
                collect.addAll(c.getRequiredRoles_InterfaceRequiringEntity().stream().filter(p -> p instanceof OperationRequiredRole).map(p -> (OperationRequiredRole)p).collect(Collectors.toList()));
            }
        } else if (split.length == 1) {
            collect = this.requiredRoles.stream().filter(r -> r instanceof OperationRequiredRole).map(r -> (OperationRequiredRole)r).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getOperationRequiredRoleFromList(actualName, collect);
    }

    private OperationRequiredRole getOperationRequiredRoleFromList(String name, List<OperationRequiredRole> requiredRoles) {
        List collect = requiredRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one operation required role with name '" + name + "' found.");
        }
        return (OperationRequiredRole)collect.get(0);
    }

    public InfrastructureRequiredRole getInfrastructureRequiredRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<InfrastructureRequiredRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r2 = this.getRepositoryByName(split[0]);
            if (r2 == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r2.getComponents__Repository()) {
                collect.addAll(c.getRequiredRoles_InterfaceRequiringEntity().stream().filter(p -> p instanceof InfrastructureRequiredRole).map(p -> (InfrastructureRequiredRole)p).collect(Collectors.toList()));
            }
        } else if (split.length == 1) {
            collect = this.requiredRoles.stream().filter(r -> r instanceof InfrastructureRequiredRole).map(r -> (InfrastructureRequiredRole)r).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getInfrastructureRequiredRoleFromList(actualName, collect);
    }

    private InfrastructureRequiredRole getInfrastructureRequiredRoleFromList(String name, List<InfrastructureRequiredRole> requiredRoles) {
        List collect = requiredRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one infrastructure required role with name '" + name + "' found.");
        }
        return (InfrastructureRequiredRole)collect.get(0);
    }

    public SourceRole getSourceRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<SourceRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r2 = this.getRepositoryByName(split[0]);
            if (r2 == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r2.getComponents__Repository()) {
                collect.addAll(c.getRequiredRoles_InterfaceRequiringEntity().stream().filter(p -> p instanceof SourceRole).map(p -> (SourceRole)p).collect(Collectors.toList()));
            }
        } else if (split.length == 1) {
            collect = this.requiredRoles.stream().filter(r -> r instanceof SourceRole).map(r -> (SourceRole)r).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getSourceRoleFromList(actualName, collect);
    }

    private SourceRole getSourceRoleFromList(String name, List<SourceRole> requiredRoles) {
        List collect = requiredRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one source role with name '" + name + "' found.");
        }
        return (SourceRole)collect.get(0);
    }

    public ResourceRequiredRole getResourceRequiredRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<ResourceRequiredRole> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r.getComponents__Repository()) {
                collect.addAll((Collection<ResourceRequiredRole>)c.getResourceRequiredRoles__ResourceInterfaceRequiringEntity());
            }
        } else if (split.length == 1) {
            collect = this.resourceRequiredRoles;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getResourceRequiredRoleFromList(actualName, collect);
    }

    private ResourceRequiredRole getResourceRequiredRoleFromList(String name, List<ResourceRequiredRole> resourceRequiredRoles) {
        List collect = resourceRequiredRoles.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one resource required role with name '" + name + "' found.");
        }
        return (ResourceRequiredRole)collect.get(0);
    }

    public Signature getSignature(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<Signature> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (org.palladiosimulator.pcm.repository.Interface i : r.getInterfaces__Repository()) {
                if (i instanceof OperationInterface var8_8) {
                    collect.addAll((Collection<Signature>)e.getSignatures__OperationInterface());
                    continue;
                }
                if (i instanceof InfrastructureInterface var10_10) {
                    collect.addAll((Collection<Signature>)e.getInfrastructureSignatures__InfrastructureInterface());
                    continue;
                }
                if (!(i instanceof EventGroup var12_12)) continue;
                collect.addAll((Collection<Signature>)e.getEventTypes__EventGroup());
            }
        } else if (split.length == 1) {
            collect = this.signatures;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getSignatureFromList(actualName, collect);
    }

    private Signature getSignatureFromList(String name, List<Signature> signatures) {
        List collect = signatures.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one signature with name '" + name + "' found.");
        }
        return (Signature)collect.get(0);
    }

    public OperationSignature getOperationSignature(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<OperationSignature> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (org.palladiosimulator.pcm.repository.Interface i2 : r.getInterfaces__Repository()) {
                if (!(i2 instanceof OperationInterface var8_8)) continue;
                collect.addAll((Collection<OperationSignature>)e.getSignatures__OperationInterface());
            }
        } else if (split.length == 1) {
            collect = this.signatures.stream().filter(i -> i instanceof OperationSignature).map(i -> (OperationSignature)i).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getOperationSignatureFromList(actualName, collect);
    }

    private OperationSignature getOperationSignatureFromList(String name, List<OperationSignature> signatures) {
        List collect = signatures.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one operation signature with name '" + name + "' found.");
        }
        return (OperationSignature)collect.get(0);
    }

    public InfrastructureSignature getInfrastructureSignature(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<InfrastructureSignature> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (org.palladiosimulator.pcm.repository.Interface i2 : r.getInterfaces__Repository()) {
                if (!(i2 instanceof InfrastructureInterface var8_8)) continue;
                collect.addAll((Collection<InfrastructureSignature>)e.getInfrastructureSignatures__InfrastructureInterface());
            }
        } else if (split.length == 1) {
            collect = this.signatures.stream().filter(i -> i instanceof InfrastructureSignature).map(i -> (InfrastructureSignature)i).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getInfrastructureSignatureFromList(actualName, collect);
    }

    private InfrastructureSignature getInfrastructureSignatureFromList(String name, List<InfrastructureSignature> signatures) {
        List collect = signatures.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one infrastructure signature with name '" + name + "' found.");
        }
        return (InfrastructureSignature)collect.get(0);
    }

    public EventType getEventType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<EventType> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (org.palladiosimulator.pcm.repository.Interface i2 : r.getInterfaces__Repository()) {
                if (!(i2 instanceof EventGroup var8_8)) continue;
                collect.addAll((Collection<EventType>)e.getEventTypes__EventGroup());
            }
        } else if (split.length == 1) {
            collect = this.signatures.stream().filter(i -> i instanceof EventType).map(i -> (EventType)i).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getEventTypeFromList(actualName, collect);
    }

    private EventType getEventTypeFromList(String name, List<EventType> signatures) {
        List collect = signatures.stream().filter(c -> c.getEntityName() != null && c.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one event type with name '" + name + "' found.");
        }
        return (EventType)collect.get(0);
    }

    public AssemblyContext getAssemblyContext(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<AssemblyContext> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r.getComponents__Repository()) {
                if (!(c instanceof ComposedProvidingRequiringEntity var8_8)) continue;
                collect.addAll((Collection<AssemblyContext>)cc.getAssemblyContexts__ComposedStructure());
            }
        } else if (split.length == 1) {
            collect = this.assemblyContexts;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getAssemblyContextFromList(actualName, collect);
    }

    private AssemblyContext getAssemblyContextFromList(String name, List<AssemblyContext> assemblyContexts) {
        List collect = assemblyContexts.stream().filter(a -> a.getEntityName() != null && a.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one assembly context with name '" + name + "' found.");
        }
        return (AssemblyContext)collect.get(0);
    }

    public EventChannel getEventChannel(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<EventChannel> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r.getComponents__Repository()) {
                if (!(c instanceof ComposedProvidingRequiringEntity var8_8)) continue;
                collect.addAll((Collection<EventChannel>)cc.getEventChannel__ComposedStructure());
            }
        } else if (split.length == 1) {
            collect = this.eventChannels;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getEventChannelFromList(actualName, collect);
    }

    private EventChannel getEventChannelFromList(String name, List<EventChannel> eventChannels) {
        List collect = eventChannels.stream().filter(a -> a.getEntityName() != null && a.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one event channel with name '" + name + "' found.");
        }
        return (EventChannel)collect.get(0);
    }

    public Parameter getParameter(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<Parameter> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (org.palladiosimulator.pcm.repository.Interface i : r.getInterfaces__Repository()) {
                if (i instanceof OperationInterface var8_8) {
                    for (InfrastructureInterface s : e.getSignatures__OperationInterface()) {
                        collect.addAll((Collection<Parameter>)s.getParameters__OperationSignature());
                    }
                    continue;
                }
                if (i instanceof InfrastructureInterface s) {
                    for (EventGroup s : e.getInfrastructureSignatures__InfrastructureInterface()) {
                        collect.addAll((Collection<Parameter>)s.getParameters__InfrastructureSignature());
                    }
                    continue;
                }
                if (!(i instanceof EventGroup s)) continue;
                for (EventType s : e.getEventTypes__EventGroup()) {
                    collect.add(s.getParameter__EventType());
                }
            }
        } else if (split.length == 1) {
            collect = this.parameters;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getParameterFromList(actualName, collect);
    }

    private Parameter getParameterFromList(String name, List<Parameter> parameters) {
        List collect = parameters.stream().filter(p -> p.getParameterName() != null && p.getParameterName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one parameter with name '" + name + "' found.");
        }
        return (Parameter)collect.get(0);
    }

    public Parameter getParameter(String name, Signature context) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(context, "context must not be null");
        String actualName = name;
        ArrayList<Parameter> collect = new ArrayList<Parameter>();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
        } else if (split.length != 1) {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        if (context instanceof OperationSignature) {
            collect.addAll((Collection<Parameter>)((OperationSignature)context).getParameters__OperationSignature());
        } else if (context instanceof InfrastructureSignature) {
            collect.addAll((Collection<Parameter>)((InfrastructureSignature)context).getParameters__InfrastructureSignature());
        } else if (context instanceof EventType) {
            collect.add(((EventType)context).getParameter__EventType());
        }
        return this.getParameterFromList(actualName, collect);
    }

    public PassiveResource getPassiveResource(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<PassiveResource> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            for (RepositoryComponent c : r.getComponents__Repository()) {
                if (!(c instanceof BasicComponent var8_8)) continue;
                collect.addAll((Collection<PassiveResource>)cc.getPassiveResource_BasicComponent());
            }
        } else if (split.length == 1) {
            collect = this.passiveResources;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getPassiveResourceFromList(actualName, collect);
    }

    private PassiveResource getPassiveResourceFromList(String name, List<PassiveResource> passiveResources) {
        List collect = passiveResources.stream().filter(b -> b.getEntityName() != null && b.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one passive resource with name '" + name + "' found.");
        }
        return (PassiveResource)collect.get(0);
    }

    public RecoveryActionBehaviour getRecoveryActionBehaviour(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        String actualName = name;
        ArrayList<RecoveryActionBehaviour> collect = new ArrayList();
        String[] split = name.split("\\.");
        if (split.length == 2) {
            actualName = split[1];
            Repository r = this.getRepositoryByName(split[0]);
            if (r == null) {
                throw new FluentApiException("Repository '" + split[0] + "' could not be found");
            }
            HashSet set = new HashSet();
            for (RepositoryComponent c : r.getComponents__Repository()) {
                if (!(c instanceof BasicComponent var9_9)) continue;
                EList seffs = cc.getServiceEffectSpecifications__BasicComponent();
                for (ServiceEffectSpecification s : seffs) {
                    if (!(s instanceof ResourceDemandingSEFF var14_14)) continue;
                    List recoveryActions = rseff.getSteps_Behaviour().stream().filter(step -> step instanceof RecoveryAction).map(step -> (RecoveryAction)step).collect(Collectors.toList());
                    for (RecoveryAction a : recoveryActions) {
                        set.addAll(a.getRecoveryActionBehaviours__RecoveryAction());
                    }
                }
            }
            collect.addAll(set);
        } else if (split.length == 1) {
            collect = this.behaviours;
        } else {
            throw new IllegalArgumentException("To access entities from imported repositories use the format <importedRepositoryName>.<entityName>");
        }
        return this.getRecoveryActionBehaviourFromList(actualName, collect);
    }

    private RecoveryActionBehaviour getRecoveryActionBehaviourFromList(String name, List<RecoveryActionBehaviour> behaviours) {
        List collect = behaviours.stream().filter(b -> b.getEntityName() != null && b.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one recovery action behaviour with name '" + name + "' found.");
        }
        return (RecoveryActionBehaviour)collect.get(0);
    }

    public void addComponent(RepositoryComponent c) {
        this.components.add(c);
    }

    public void addInterface(org.palladiosimulator.pcm.repository.Interface i) {
        this.interfaces.add(i);
    }

    public void addProvidedRole(ProvidedRole pr) {
        this.providedRoles.add(pr);
    }

    public void addRequiredRole(RequiredRole rr) {
        this.requiredRoles.add(rr);
    }

    public void addResourceRequiredRole(ResourceRequiredRole rr) {
        this.resourceRequiredRoles.add(rr);
    }

    public void addSignature(Signature sign) {
        this.signatures.add(sign);
    }

    public void addAssemblyContext(AssemblyContext ac) {
        this.assemblyContexts.add(ac);
    }

    public void addConnector(Connector r) {
        this.connectors.add(r);
    }

    public void addEventChannel(EventChannel eg) {
        this.eventChannels.add(eg);
    }

    public void addParameter(Parameter p) {
        this.parameters.add(p);
    }

    public void addPassiveResource(PassiveResource pass) {
        this.passiveResources.add(pass);
    }

    public void addRecoveryActionBehaviour(RecoveryActionBehaviour recovery) {
        this.behaviours.add(recovery);
    }
}

