/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.event;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.event.SinkRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.core.composition.EventChannelSinkConnector;
import org.palladiosimulator.pcm.repository.SinkRole;

public class EventChannelSinkConnectorCreator
extends AbstractConnectorCreator {
    private EventChannel eventChannel;
    private AssemblyContext assemblyContext;
    private SinkRole role;

    public EventChannelSinkConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public EventChannelSinkConnectorCreator withEventChannel(EventChannel eventChannel) {
        IllegalArgumentException.throwIfNull(eventChannel, "The given EventChannel must not be null.");
        this.eventChannel = eventChannel;
        return this;
    }

    public EventChannelSinkConnectorCreator withEventChannel(String name) throws NoSuchElementException {
        EventChannel channel = this.system.getEventChannelByName(name);
        return this.withEventChannel(channel);
    }

    public SinkRoleSelector<EventChannelSinkConnectorCreator> withAssemblyContext(AssemblyContext assemblyContext) {
        IllegalArgumentException.throwIfNull(assemblyContext, "The given AssemblyContext must not be null.");
        return new SinkRoleSelector<EventChannelSinkConnectorCreator>((context, role) -> {
            this.assemblyContext = context;
            this.role = role;
            return this;
        }, assemblyContext);
    }

    public SinkRoleSelector<EventChannelSinkConnectorCreator> withAssemblyContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withAssemblyContext(context);
    }

    public EventChannelSinkConnector build() {
        EventChannelSinkConnector connector = CompositionFactory.eINSTANCE.createEventChannelSinkConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setEventChannel__EventChannelSinkConnector(this.eventChannel);
        connector.setAssemblyContext__EventChannelSinkConnector(this.assemblyContext);
        connector.setSinkRole__EventChannelSinkConnector(this.role);
        return connector;
    }

    @Override
    public EventChannelSinkConnectorCreator withName(String name) {
        return (EventChannelSinkConnectorCreator)super.withName(name);
    }
}

