/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.role;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class InfrastructureProvidedRoleCreator
extends SystemEntity {
    private InfrastructureInterface providedInterface;

    public InfrastructureProvidedRoleCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public InfrastructureProvidedRoleCreator withProvidedInterface(InfrastructureInterface infrastructureInterface) {
        IllegalArgumentException.throwIfNull(infrastructureInterface, "The given Interface must not be null.");
        this.providedInterface = infrastructureInterface;
        return this;
    }

    public InfrastructureProvidedRoleCreator withProvidedInterface(String name) throws NoSuchElementException {
        InfrastructureInterface requiredInterface;
        try {
            requiredInterface = (InfrastructureInterface)this.system.getInterfaceByName(name);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("An Interface with name '%s' was found, but it was not an InfrastructureInterface. Please make sure all names are unique.", name), e);
        }
        return this.withProvidedInterface(requiredInterface);
    }

    public InfrastructureProvidedRole build() {
        InfrastructureProvidedRole role = RepositoryFactory.eINSTANCE.createInfrastructureProvidedRole();
        if (this.name != null) {
            role.setEntityName(this.name);
        }
        role.setProvidedInterface__InfrastructureProvidedRole(this.providedInterface);
        return role;
    }

    @Override
    public InfrastructureProvidedRoleCreator withName(String name) {
        return (InfrastructureProvidedRoleCreator)super.withName(name);
    }
}

